<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRequest StructType
 * @subpackage Structs
 */
class ProductRequest extends AbstractStructBase
{
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The domestic
     * @var bool
     */
    public $domestic;
    /**
     * The category
     * @var \StructType\CategoryRequest
     */
    public $category;
    /**
     * The specialProductInfoList
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpecialProductInfoList
     */
    public $specialProductInfoList;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The groupAttribute
     * @var string
     */
    public $groupAttribute;
    /**
     * The groupItemCode
     * @var string
     */
    public $groupItemCode;
    /**
     * The itemName
     * @var string
     */
    public $itemName;
    /**
     * The attributes
     * @var \StructType\ProductAttributeRequestList
     */
    public $attributes;
    /**
     * The productionDate
     * @var string
     */
    public $productionDate;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The productCondition
     * @var string
     */
    public $productCondition;
    /**
     * The preparingDay
     * @var int
     */
    public $preparingDay;
    /**
     * The discount
     * @var \StructType\ProductDiscountRequest
     */
    public $discount;
    /**
     * The shipmentTemplate
     * @var string
     */
    public $shipmentTemplate;
    /**
     * The stockItems
     * @var \StructType\ProductSkuRequestList
     */
    public $stockItems;
    /**
     * The unitInfo
     * @var \StructType\ProductUnitInfoModel
     */
    public $unitInfo;
    /**
     * The maxPurchaseQuantity
     * @var int
     */
    public $maxPurchaseQuantity;
    /**
     * The sellerNote
     * @var string
     */
    public $sellerNote;
    /**
     * Constructor method for ProductRequest
     * @uses ProductRequest::setProductSellerCode()
     * @uses ProductRequest::setTitle()
     * @uses ProductRequest::setDescription()
     * @uses ProductRequest::setDomestic()
     * @uses ProductRequest::setCategory()
     * @uses ProductRequest::setSpecialProductInfoList()
     * @uses ProductRequest::setPrice()
     * @uses ProductRequest::setCurrencyType()
     * @uses ProductRequest::setImages()
     * @uses ProductRequest::setApprovalStatus()
     * @uses ProductRequest::setGroupAttribute()
     * @uses ProductRequest::setGroupItemCode()
     * @uses ProductRequest::setItemName()
     * @uses ProductRequest::setAttributes()
     * @uses ProductRequest::setProductionDate()
     * @uses ProductRequest::setExpirationDate()
     * @uses ProductRequest::setProductCondition()
     * @uses ProductRequest::setPreparingDay()
     * @uses ProductRequest::setDiscount()
     * @uses ProductRequest::setShipmentTemplate()
     * @uses ProductRequest::setStockItems()
     * @uses ProductRequest::setUnitInfo()
     * @uses ProductRequest::setMaxPurchaseQuantity()
     * @uses ProductRequest::setSellerNote()
     * @param string $productSellerCode
     * @param string $title
     * @param string $description
     * @param bool $domestic
     * @param \StructType\CategoryRequest $category
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @param float $price
     * @param int $currencyType
     * @param \StructType\ProductImageList $images
     * @param int $approvalStatus
     * @param string $groupAttribute
     * @param string $groupItemCode
     * @param string $itemName
     * @param \StructType\ProductAttributeRequestList $attributes
     * @param string $productionDate
     * @param string $expirationDate
     * @param string $productCondition
     * @param int $preparingDay
     * @param \StructType\ProductDiscountRequest $discount
     * @param string $shipmentTemplate
     * @param \StructType\ProductSkuRequestList $stockItems
     * @param \StructType\ProductUnitInfoModel $unitInfo
     * @param int $maxPurchaseQuantity
     * @param string $sellerNote
     */
    public function __construct($productSellerCode = null, $title = null, $description = null, $domestic = null, \StructType\CategoryRequest $category = null, \StructType\SpecialProductInfoList $specialProductInfoList = null, $price = null, $currencyType = null, \StructType\ProductImageList $images = null, $approvalStatus = null, $groupAttribute = null, $groupItemCode = null, $itemName = null, \StructType\ProductAttributeRequestList $attributes = null, $productionDate = null, $expirationDate = null, $productCondition = null, $preparingDay = null, \StructType\ProductDiscountRequest $discount = null, $shipmentTemplate = null, \StructType\ProductSkuRequestList $stockItems = null, \StructType\ProductUnitInfoModel $unitInfo = null, $maxPurchaseQuantity = null, $sellerNote = null)
    {
        $this
            ->setProductSellerCode($productSellerCode)
            ->setTitle($title)
            ->setDescription($description)
            ->setDomestic($domestic)
            ->setCategory($category)
            ->setSpecialProductInfoList($specialProductInfoList)
            ->setPrice($price)
            ->setCurrencyType($currencyType)
            ->setImages($images)
            ->setApprovalStatus($approvalStatus)
            ->setGroupAttribute($groupAttribute)
            ->setGroupItemCode($groupItemCode)
            ->setItemName($itemName)
            ->setAttributes($attributes)
            ->setProductionDate($productionDate)
            ->setExpirationDate($expirationDate)
            ->setProductCondition($productCondition)
            ->setPreparingDay($preparingDay)
            ->setDiscount($discount)
            ->setShipmentTemplate($shipmentTemplate)
            ->setStockItems($stockItems)
            ->setUnitInfo($unitInfo)
            ->setMaxPurchaseQuantity($maxPurchaseQuantity)
            ->setSellerNote($sellerNote);
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProductRequest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProductRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domestic value
     * @return bool|null
     */
    public function getDomestic()
    {
        return $this->domestic;
    }
    /**
     * Set domestic value
     * @param bool $domestic
     * @return \StructType\ProductRequest
     */
    public function setDomestic($domestic = null)
    {
        // validation for constraint: boolean
        if (!is_null($domestic) && !is_bool($domestic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($domestic, true), gettype($domestic)), __LINE__);
        }
        $this->domestic = $domestic;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\CategoryRequest|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\CategoryRequest $category
     * @return \StructType\ProductRequest
     */
    public function setCategory(\StructType\CategoryRequest $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get specialProductInfoList value
     * @return \StructType\SpecialProductInfoList|null
     */
    public function getSpecialProductInfoList()
    {
        return $this->specialProductInfoList;
    }
    /**
     * Set specialProductInfoList value
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @return \StructType\ProductRequest
     */
    public function setSpecialProductInfoList(\StructType\SpecialProductInfoList $specialProductInfoList = null)
    {
        $this->specialProductInfoList = $specialProductInfoList;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductRequest
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\ProductRequest
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !(is_int($currencyType) || ctype_digit($currencyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyType, true), gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\ProductRequest
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\ProductRequest
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !(is_int($approvalStatus) || ctype_digit($approvalStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($approvalStatus, true), gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get groupAttribute value
     * @return string|null
     */
    public function getGroupAttribute()
    {
        return $this->groupAttribute;
    }
    /**
     * Set groupAttribute value
     * @param string $groupAttribute
     * @return \StructType\ProductRequest
     */
    public function setGroupAttribute($groupAttribute = null)
    {
        // validation for constraint: string
        if (!is_null($groupAttribute) && !is_string($groupAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupAttribute, true), gettype($groupAttribute)), __LINE__);
        }
        $this->groupAttribute = $groupAttribute;
        return $this;
    }
    /**
     * Get groupItemCode value
     * @return string|null
     */
    public function getGroupItemCode()
    {
        return $this->groupItemCode;
    }
    /**
     * Set groupItemCode value
     * @param string $groupItemCode
     * @return \StructType\ProductRequest
     */
    public function setGroupItemCode($groupItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupItemCode) && !is_string($groupItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupItemCode, true), gettype($groupItemCode)), __LINE__);
        }
        $this->groupItemCode = $groupItemCode;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\ProductRequest
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeRequestList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeRequestList $attributes
     * @return \StructType\ProductRequest
     */
    public function setAttributes(\StructType\ProductAttributeRequestList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get productionDate value
     * @return string|null
     */
    public function getProductionDate()
    {
        return $this->productionDate;
    }
    /**
     * Set productionDate value
     * @param string $productionDate
     * @return \StructType\ProductRequest
     */
    public function setProductionDate($productionDate = null)
    {
        // validation for constraint: string
        if (!is_null($productionDate) && !is_string($productionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productionDate, true), gettype($productionDate)), __LINE__);
        }
        $this->productionDate = $productionDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\ProductRequest
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get productCondition value
     * @return string|null
     */
    public function getProductCondition()
    {
        return $this->productCondition;
    }
    /**
     * Set productCondition value
     * @param string $productCondition
     * @return \StructType\ProductRequest
     */
    public function setProductCondition($productCondition = null)
    {
        // validation for constraint: string
        if (!is_null($productCondition) && !is_string($productCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCondition, true), gettype($productCondition)), __LINE__);
        }
        $this->productCondition = $productCondition;
        return $this;
    }
    /**
     * Get preparingDay value
     * @return int|null
     */
    public function getPreparingDay()
    {
        return $this->preparingDay;
    }
    /**
     * Set preparingDay value
     * @param int $preparingDay
     * @return \StructType\ProductRequest
     */
    public function setPreparingDay($preparingDay = null)
    {
        // validation for constraint: int
        if (!is_null($preparingDay) && !(is_int($preparingDay) || ctype_digit($preparingDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preparingDay, true), gettype($preparingDay)), __LINE__);
        }
        $this->preparingDay = $preparingDay;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\ProductDiscountRequest|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\ProductDiscountRequest $discount
     * @return \StructType\ProductRequest
     */
    public function setDiscount(\StructType\ProductDiscountRequest $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get shipmentTemplate value
     * @return string|null
     */
    public function getShipmentTemplate()
    {
        return $this->shipmentTemplate;
    }
    /**
     * Set shipmentTemplate value
     * @param string $shipmentTemplate
     * @return \StructType\ProductRequest
     */
    public function setShipmentTemplate($shipmentTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTemplate) && !is_string($shipmentTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentTemplate, true), gettype($shipmentTemplate)), __LINE__);
        }
        $this->shipmentTemplate = $shipmentTemplate;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuRequestList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuRequestList $stockItems
     * @return \StructType\ProductRequest
     */
    public function setStockItems(\StructType\ProductSkuRequestList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get unitInfo value
     * @return \StructType\ProductUnitInfoModel|null
     */
    public function getUnitInfo()
    {
        return $this->unitInfo;
    }
    /**
     * Set unitInfo value
     * @param \StructType\ProductUnitInfoModel $unitInfo
     * @return \StructType\ProductRequest
     */
    public function setUnitInfo(\StructType\ProductUnitInfoModel $unitInfo = null)
    {
        $this->unitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get maxPurchaseQuantity value
     * @return int|null
     */
    public function getMaxPurchaseQuantity()
    {
        return $this->maxPurchaseQuantity;
    }
    /**
     * Set maxPurchaseQuantity value
     * @param int $maxPurchaseQuantity
     * @return \StructType\ProductRequest
     */
    public function setMaxPurchaseQuantity($maxPurchaseQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxPurchaseQuantity) && !(is_int($maxPurchaseQuantity) || ctype_digit($maxPurchaseQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPurchaseQuantity, true), gettype($maxPurchaseQuantity)), __LINE__);
        }
        $this->maxPurchaseQuantity = $maxPurchaseQuantity;
        return $this;
    }
    /**
     * Get sellerNote value
     * @return string|null
     */
    public function getSellerNote()
    {
        return $this->sellerNote;
    }
    /**
     * Set sellerNote value
     * @param string $sellerNote
     * @return \StructType\ProductRequest
     */
    public function setSellerNote($sellerNote = null)
    {
        // validation for constraint: string
        if (!is_null($sellerNote) && !is_string($sellerNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerNote, true), gettype($sellerNote)), __LINE__);
        }
        $this->sellerNote = $sellerNote;
        return $this;
    }
}
