<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestionList StructType
 * @subpackage Structs
 */
class ProductQuestionList extends AbstractStructBase
{
    /**
     * The productQuestion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductQuestion[]
     */
    public $productQuestion;
    /**
     * Constructor method for ProductQuestionList
     * @uses ProductQuestionList::setProductQuestion()
     * @param \StructType\ProductQuestion[] $productQuestion
     */
    public function __construct(array $productQuestion = array())
    {
        $this
            ->setProductQuestion($productQuestion);
    }
    /**
     * Get productQuestion value
     * @return \StructType\ProductQuestion[]|null
     */
    public function getProductQuestion()
    {
        return $this->productQuestion;
    }
    /**
     * This method is responsible for validating the values passed to the setProductQuestion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductQuestion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductQuestionForArrayConstraintsFromSetProductQuestion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productQuestionListProductQuestionItem) {
            // validation for constraint: itemType
            if (!$productQuestionListProductQuestionItem instanceof \StructType\ProductQuestion) {
                $invalidValues[] = is_object($productQuestionListProductQuestionItem) ? get_class($productQuestionListProductQuestionItem) : sprintf('%s(%s)', gettype($productQuestionListProductQuestionItem), var_export($productQuestionListProductQuestionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productQuestion property can only contain items of type \StructType\ProductQuestion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productQuestion value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductQuestion[] $productQuestion
     * @return \StructType\ProductQuestionList
     */
    public function setProductQuestion(array $productQuestion = array())
    {
        // validation for constraint: array
        if ('' !== ($productQuestionArrayErrorMessage = self::validateProductQuestionForArrayConstraintsFromSetProductQuestion($productQuestion))) {
            throw new \InvalidArgumentException($productQuestionArrayErrorMessage, __LINE__);
        }
        $this->productQuestion = $productQuestion;
        return $this;
    }
    /**
     * Add item to productQuestion value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductQuestion $item
     * @return \StructType\ProductQuestionList
     */
    public function addToProductQuestion(\StructType\ProductQuestion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductQuestion) {
            throw new \InvalidArgumentException(sprintf('The productQuestion property can only contain items of type \StructType\ProductQuestion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productQuestion[] = $item;
        return $this;
    }
}
