<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductBasic StructType
 * @subpackage Structs
 */
class ProductBasic extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The isDomestic
     * @var bool
     */
    public $isDomestic;
    /**
     * The saleStatus
     * @var int
     */
    public $saleStatus;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The stockItems
     * @var \StructType\ProductSkuList
     */
    public $stockItems;
    /**
     * The oldPrice
     * @var float
     */
    public $oldPrice;
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * The productStatusDetail
     * @var string
     */
    public $productStatusDetail;
    /**
     * Constructor method for ProductBasic
     * @uses ProductBasic::setId()
     * @uses ProductBasic::setProductSellerCode()
     * @uses ProductBasic::setTitle()
     * @uses ProductBasic::setPrice()
     * @uses ProductBasic::setDisplayPrice()
     * @uses ProductBasic::setIsDomestic()
     * @uses ProductBasic::setSaleStatus()
     * @uses ProductBasic::setApprovalStatus()
     * @uses ProductBasic::setStockItems()
     * @uses ProductBasic::setOldPrice()
     * @uses ProductBasic::setCurrencyAmount()
     * @uses ProductBasic::setCurrencyType()
     * @uses ProductBasic::setProductStatusDetail()
     * @param int $id
     * @param string $productSellerCode
     * @param string $title
     * @param float $price
     * @param float $displayPrice
     * @param bool $isDomestic
     * @param int $saleStatus
     * @param int $approvalStatus
     * @param \StructType\ProductSkuList $stockItems
     * @param float $oldPrice
     * @param float $currencyAmount
     * @param int $currencyType
     * @param string $productStatusDetail
     */
    public function __construct($id = null, $productSellerCode = null, $title = null, $price = null, $displayPrice = null, $isDomestic = null, $saleStatus = null, $approvalStatus = null, \StructType\ProductSkuList $stockItems = null, $oldPrice = null, $currencyAmount = null, $currencyType = null, $productStatusDetail = null)
    {
        $this
            ->setId($id)
            ->setProductSellerCode($productSellerCode)
            ->setTitle($title)
            ->setPrice($price)
            ->setDisplayPrice($displayPrice)
            ->setIsDomestic($isDomestic)
            ->setSaleStatus($saleStatus)
            ->setApprovalStatus($approvalStatus)
            ->setStockItems($stockItems)
            ->setOldPrice($oldPrice)
            ->setCurrencyAmount($currencyAmount)
            ->setCurrencyType($currencyType)
            ->setProductStatusDetail($productStatusDetail);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductBasic
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductBasic
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProductBasic
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductBasic
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\ProductBasic
     */
    public function setDisplayPrice($displayPrice = null)
    {
        // validation for constraint: float
        if (!is_null($displayPrice) && !(is_float($displayPrice) || is_numeric($displayPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($displayPrice, true), gettype($displayPrice)), __LINE__);
        }
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get isDomestic value
     * @return bool|null
     */
    public function getIsDomestic()
    {
        return $this->isDomestic;
    }
    /**
     * Set isDomestic value
     * @param bool $isDomestic
     * @return \StructType\ProductBasic
     */
    public function setIsDomestic($isDomestic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDomestic) && !is_bool($isDomestic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDomestic, true), gettype($isDomestic)), __LINE__);
        }
        $this->isDomestic = $isDomestic;
        return $this;
    }
    /**
     * Get saleStatus value
     * @return int|null
     */
    public function getSaleStatus()
    {
        return $this->saleStatus;
    }
    /**
     * Set saleStatus value
     * @param int $saleStatus
     * @return \StructType\ProductBasic
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: int
        if (!is_null($saleStatus) && !(is_int($saleStatus) || ctype_digit($saleStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleStatus, true), gettype($saleStatus)), __LINE__);
        }
        $this->saleStatus = $saleStatus;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\ProductBasic
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !(is_int($approvalStatus) || ctype_digit($approvalStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($approvalStatus, true), gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuList $stockItems
     * @return \StructType\ProductBasic
     */
    public function setStockItems(\StructType\ProductSkuList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get oldPrice value
     * @return float|null
     */
    public function getOldPrice()
    {
        return $this->oldPrice;
    }
    /**
     * Set oldPrice value
     * @param float $oldPrice
     * @return \StructType\ProductBasic
     */
    public function setOldPrice($oldPrice = null)
    {
        // validation for constraint: float
        if (!is_null($oldPrice) && !(is_float($oldPrice) || is_numeric($oldPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oldPrice, true), gettype($oldPrice)), __LINE__);
        }
        $this->oldPrice = $oldPrice;
        return $this;
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\ProductBasic
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($currencyAmount) && !(is_float($currencyAmount) || is_numeric($currencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyAmount, true), gettype($currencyAmount)), __LINE__);
        }
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\ProductBasic
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !(is_int($currencyType) || ctype_digit($currencyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyType, true), gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Get productStatusDetail value
     * @return string|null
     */
    public function getProductStatusDetail()
    {
        return $this->productStatusDetail;
    }
    /**
     * Set productStatusDetail value
     * @param string $productStatusDetail
     * @return \StructType\ProductBasic
     */
    public function setProductStatusDetail($productStatusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($productStatusDetail) && !is_string($productStatusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productStatusDetail, true), gettype($productStatusDetail)), __LINE__);
        }
        $this->productStatusDetail = $productStatusDetail;
        return $this;
    }
}
