<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDiscountValueBySellerCodeRequest StructType
 * @subpackage Structs
 */
class UpdateDiscountValueBySellerCodeRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The productDiscount
     * @var \StructType\SellerProductDiscount
     */
    public $productDiscount;
    /**
     * Constructor method for UpdateDiscountValueBySellerCodeRequest
     * @uses UpdateDiscountValueBySellerCodeRequest::setAuth()
     * @uses UpdateDiscountValueBySellerCodeRequest::setProductSellerCode()
     * @uses UpdateDiscountValueBySellerCodeRequest::setProductDiscount()
     * @param \StructType\Authentication $auth
     * @param string $productSellerCode
     * @param \StructType\SellerProductDiscount $productDiscount
     */
    public function __construct(\StructType\Authentication $auth = null, $productSellerCode = null, \StructType\SellerProductDiscount $productDiscount = null)
    {
        $this
            ->setAuth($auth)
            ->setProductSellerCode($productSellerCode)
            ->setProductDiscount($productDiscount);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateDiscountValueBySellerCodeRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\UpdateDiscountValueBySellerCodeRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get productDiscount value
     * @return \StructType\SellerProductDiscount|null
     */
    public function getProductDiscount()
    {
        return $this->productDiscount;
    }
    /**
     * Set productDiscount value
     * @param \StructType\SellerProductDiscount $productDiscount
     * @return \StructType\UpdateDiscountValueBySellerCodeRequest
     */
    public function setProductDiscount(\StructType\SellerProductDiscount $productDiscount = null)
    {
        $this->productDiscount = $productDiscount;
        return $this;
    }
}
