<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForUpdateStockWithAttributes StructType
 * @subpackage Structs
 */
class StockItemForUpdateStockWithAttributes extends AbstractStructBase
{
    /**
     * The attributes
     * @var \StructType\StockAttributeList
     */
    public $attributes;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForUpdateStockWithAttributes
     * @uses StockItemForUpdateStockWithAttributes::setAttributes()
     * @uses StockItemForUpdateStockWithAttributes::setQuantity()
     * @uses StockItemForUpdateStockWithAttributes::setVersion()
     * @param \StructType\StockAttributeList $attributes
     * @param int $quantity
     * @param int $version
     */
    public function __construct(\StructType\StockAttributeList $attributes = null, $quantity = null, $version = null)
    {
        $this
            ->setAttributes($attributes)
            ->setQuantity($quantity)
            ->setVersion($version);
    }
    /**
     * Get attributes value
     * @return \StructType\StockAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\StockAttributeList $attributes
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setAttributes(\StructType\StockAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
