<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithAttributesList StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithAttributesList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForAddStockWithAttributes[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForAddStockWithAttributesList
     * @uses StockItemForAddStockWithAttributesList::setStockItem()
     * @param \StructType\StockItemForAddStockWithAttributes[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForAddStockWithAttributes[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemForArrayConstraintsFromSetStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockItemForAddStockWithAttributesListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForAddStockWithAttributesListStockItemItem instanceof \StructType\StockItemForAddStockWithAttributes) {
                $invalidValues[] = is_object($stockItemForAddStockWithAttributesListStockItemItem) ? get_class($stockItemForAddStockWithAttributesListStockItemItem) : sprintf('%s(%s)', gettype($stockItemForAddStockWithAttributesListStockItemItem), var_export($stockItemForAddStockWithAttributesListStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItem property can only contain items of type \StructType\StockItemForAddStockWithAttributes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithAttributes[] $stockItem
     * @return \StructType\StockItemForAddStockWithAttributesList
     */
    public function setStockItem(array $stockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemArrayErrorMessage = self::validateStockItemForArrayConstraintsFromSetStockItem($stockItem))) {
            throw new \InvalidArgumentException($stockItemArrayErrorMessage, __LINE__);
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithAttributes $item
     * @return \StructType\StockItemForAddStockWithAttributesList
     */
    public function addToStockItem(\StructType\StockItemForAddStockWithAttributes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForAddStockWithAttributes) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of type \StructType\StockItemForAddStockWithAttributes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
}
