<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveProductAnswerRequest StructType
 * @subpackage Structs
 */
class SaveProductAnswerRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productQuestionId
     * @var int
     */
    public $productQuestionId;
    /**
     * The answer
     * @var string
     */
    public $answer;
    /**
     * Constructor method for SaveProductAnswerRequest
     * @uses SaveProductAnswerRequest::setAuth()
     * @uses SaveProductAnswerRequest::setProductQuestionId()
     * @uses SaveProductAnswerRequest::setAnswer()
     * @param \StructType\Authentication $auth
     * @param int $productQuestionId
     * @param string $answer
     */
    public function __construct(\StructType\Authentication $auth = null, $productQuestionId = null, $answer = null)
    {
        $this
            ->setAuth($auth)
            ->setProductQuestionId($productQuestionId)
            ->setAnswer($answer);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productQuestionId value
     * @return int|null
     */
    public function getProductQuestionId()
    {
        return $this->productQuestionId;
    }
    /**
     * Set productQuestionId value
     * @param int $productQuestionId
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setProductQuestionId($productQuestionId = null)
    {
        // validation for constraint: int
        if (!is_null($productQuestionId) && !(is_int($productQuestionId) || ctype_digit($productQuestionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productQuestionId, true), gettype($productQuestionId)), __LINE__);
        }
        $this->productQuestionId = $productQuestionId;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
}
