<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithIdAndStockAttributesForUpdate StructType
 * @subpackage Structs
 */
class ProductWithIdAndStockAttributesForUpdate extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockItems
     * @var \StructType\StockItemForUpdateStockWithAttributesList
     */
    public $stockItems;
    /**
     * Constructor method for ProductWithIdAndStockAttributesForUpdate
     * @uses ProductWithIdAndStockAttributesForUpdate::setId()
     * @uses ProductWithIdAndStockAttributesForUpdate::setStockItems()
     * @param int $id
     * @param \StructType\StockItemForUpdateStockWithAttributesList $stockItems
     */
    public function __construct($id = null, \StructType\StockItemForUpdateStockWithAttributesList $stockItems = null)
    {
        $this
            ->setId($id)
            ->setStockItems($stockItems);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductWithIdAndStockAttributesForUpdate
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\StockItemForUpdateStockWithAttributesList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\StockItemForUpdateStockWithAttributesList $stockItems
     * @return \StructType\ProductWithIdAndStockAttributesForUpdate
     */
    public function setStockItems(\StructType\StockItemForUpdateStockWithAttributesList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
}
