<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductUpdateSkuBasicRequest StructType
 * @subpackage Structs
 */
class ProductUpdateSkuBasicRequest extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The optionPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $optionPrice;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for ProductUpdateSkuBasicRequest
     * @uses ProductUpdateSkuBasicRequest::setSellerStockCode()
     * @uses ProductUpdateSkuBasicRequest::setId()
     * @uses ProductUpdateSkuBasicRequest::setOptionPrice()
     * @uses ProductUpdateSkuBasicRequest::setQuantity()
     * @param string $sellerStockCode
     * @param int $id
     * @param float $optionPrice
     * @param int $quantity
     */
    public function __construct($sellerStockCode = null, $id = null, $optionPrice = null, $quantity = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setId($id)
            ->setOptionPrice($optionPrice)
            ->setQuantity($quantity);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStockCode, true), gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get optionPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOptionPrice()
    {
        return isset($this->optionPrice) ? $this->optionPrice : null;
    }
    /**
     * Set optionPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $optionPrice
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($optionPrice) && !(is_float($optionPrice) || is_numeric($optionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionPrice, true), gettype($optionPrice)), __LINE__);
        }
        if (is_null($optionPrice) || (is_array($optionPrice) && empty($optionPrice))) {
            unset($this->optionPrice);
        } else {
            $this->optionPrice = $optionPrice;
        }
        return $this;
    }
    /**
     * Get quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->quantity) ? $this->quantity : null;
    }
    /**
     * Set quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->quantity);
        } else {
            $this->quantity = $quantity;
        }
        return $this;
    }
}
