<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductApprovalStatusApi StructType
 * @subpackage Structs
 */
class ProductApprovalStatusApi extends AbstractStructBase
{
    /**
     * The approvedCount
     * @var int
     */
    public $approvedCount;
    /**
     * The unapprovedCount
     * @var int
     */
    public $unapprovedCount;
    /**
     * The waitingApprovalCount
     * @var int
     */
    public $waitingApprovalCount;
    /**
     * The waitingCount
     * @var int
     */
    public $waitingCount;
    /**
     * The rejectedCount
     * @var int
     */
    public $rejectedCount;
    /**
     * The totalCount
     * @var int
     */
    public $totalCount;
    /**
     * Constructor method for ProductApprovalStatusApi
     * @uses ProductApprovalStatusApi::setApprovedCount()
     * @uses ProductApprovalStatusApi::setUnapprovedCount()
     * @uses ProductApprovalStatusApi::setWaitingApprovalCount()
     * @uses ProductApprovalStatusApi::setWaitingCount()
     * @uses ProductApprovalStatusApi::setRejectedCount()
     * @uses ProductApprovalStatusApi::setTotalCount()
     * @param int $approvedCount
     * @param int $unapprovedCount
     * @param int $waitingApprovalCount
     * @param int $waitingCount
     * @param int $rejectedCount
     * @param int $totalCount
     */
    public function __construct($approvedCount = null, $unapprovedCount = null, $waitingApprovalCount = null, $waitingCount = null, $rejectedCount = null, $totalCount = null)
    {
        $this
            ->setApprovedCount($approvedCount)
            ->setUnapprovedCount($unapprovedCount)
            ->setWaitingApprovalCount($waitingApprovalCount)
            ->setWaitingCount($waitingCount)
            ->setRejectedCount($rejectedCount)
            ->setTotalCount($totalCount);
    }
    /**
     * Get approvedCount value
     * @return int|null
     */
    public function getApprovedCount()
    {
        return $this->approvedCount;
    }
    /**
     * Set approvedCount value
     * @param int $approvedCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setApprovedCount($approvedCount = null)
    {
        // validation for constraint: int
        if (!is_null($approvedCount) && !(is_int($approvedCount) || ctype_digit($approvedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($approvedCount, true), gettype($approvedCount)), __LINE__);
        }
        $this->approvedCount = $approvedCount;
        return $this;
    }
    /**
     * Get unapprovedCount value
     * @return int|null
     */
    public function getUnapprovedCount()
    {
        return $this->unapprovedCount;
    }
    /**
     * Set unapprovedCount value
     * @param int $unapprovedCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setUnapprovedCount($unapprovedCount = null)
    {
        // validation for constraint: int
        if (!is_null($unapprovedCount) && !(is_int($unapprovedCount) || ctype_digit($unapprovedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unapprovedCount, true), gettype($unapprovedCount)), __LINE__);
        }
        $this->unapprovedCount = $unapprovedCount;
        return $this;
    }
    /**
     * Get waitingApprovalCount value
     * @return int|null
     */
    public function getWaitingApprovalCount()
    {
        return $this->waitingApprovalCount;
    }
    /**
     * Set waitingApprovalCount value
     * @param int $waitingApprovalCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setWaitingApprovalCount($waitingApprovalCount = null)
    {
        // validation for constraint: int
        if (!is_null($waitingApprovalCount) && !(is_int($waitingApprovalCount) || ctype_digit($waitingApprovalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingApprovalCount, true), gettype($waitingApprovalCount)), __LINE__);
        }
        $this->waitingApprovalCount = $waitingApprovalCount;
        return $this;
    }
    /**
     * Get waitingCount value
     * @return int|null
     */
    public function getWaitingCount()
    {
        return $this->waitingCount;
    }
    /**
     * Set waitingCount value
     * @param int $waitingCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setWaitingCount($waitingCount = null)
    {
        // validation for constraint: int
        if (!is_null($waitingCount) && !(is_int($waitingCount) || ctype_digit($waitingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitingCount, true), gettype($waitingCount)), __LINE__);
        }
        $this->waitingCount = $waitingCount;
        return $this;
    }
    /**
     * Get rejectedCount value
     * @return int|null
     */
    public function getRejectedCount()
    {
        return $this->rejectedCount;
    }
    /**
     * Set rejectedCount value
     * @param int $rejectedCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setRejectedCount($rejectedCount = null)
    {
        // validation for constraint: int
        if (!is_null($rejectedCount) && !(is_int($rejectedCount) || ctype_digit($rejectedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rejectedCount, true), gettype($rejectedCount)), __LINE__);
        }
        $this->rejectedCount = $rejectedCount;
        return $this;
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\ProductApprovalStatusApi
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
}
