<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchProductsRequest $searchProductsRequest
     * @return \StructType\SearchProductsResponse|bool
     */
    public function SearchProducts(\StructType\SearchProductsRequest $searchProductsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchProducts($searchProductsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
