<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchProductsRequest StructType
 * @subpackage Structs
 */
class SearchProductsRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The pagingData
     * @var \StructType\RequestPagingData
     */
    public $pagingData;
    /**
     * The productSearch
     * @var \StructType\ProductSearch
     */
    public $productSearch;
    /**
     * Constructor method for SearchProductsRequest
     * @uses SearchProductsRequest::setAuth()
     * @uses SearchProductsRequest::setPagingData()
     * @uses SearchProductsRequest::setProductSearch()
     * @param \StructType\Authentication $auth
     * @param \StructType\RequestPagingData $pagingData
     * @param \StructType\ProductSearch $productSearch
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\RequestPagingData $pagingData = null, \StructType\ProductSearch $productSearch = null)
    {
        $this
            ->setAuth($auth)
            ->setPagingData($pagingData)
            ->setProductSearch($productSearch);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SearchProductsRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\RequestPagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\RequestPagingData $pagingData
     * @return \StructType\SearchProductsRequest
     */
    public function setPagingData(\StructType\RequestPagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
    /**
     * Get productSearch value
     * @return \StructType\ProductSearch|null
     */
    public function getProductSearch()
    {
        return $this->productSearch;
    }
    /**
     * Set productSearch value
     * @param \StructType\ProductSearch $productSearch
     * @return \StructType\SearchProductsRequest
     */
    public function setProductSearch(\StructType\ProductSearch $productSearch = null)
    {
        $this->productSearch = $productSearch;
        return $this;
    }
}
