<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithIdAndStockAttributes StructType
 * @subpackage Structs
 */
class ProductWithIdAndStockAttributes extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockItems
     * @var \StructType\StockItemForAddStockWithAttributesList
     */
    public $stockItems;
    /**
     * Constructor method for ProductWithIdAndStockAttributes
     * @uses ProductWithIdAndStockAttributes::setId()
     * @uses ProductWithIdAndStockAttributes::setStockItems()
     * @param int $id
     * @param \StructType\StockItemForAddStockWithAttributesList $stockItems
     */
    public function __construct($id = null, \StructType\StockItemForAddStockWithAttributesList $stockItems = null)
    {
        $this
            ->setId($id)
            ->setStockItems($stockItems);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductWithIdAndStockAttributes
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\StockItemForAddStockWithAttributesList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\StockItemForAddStockWithAttributesList $stockItems
     * @return \StructType\ProductWithIdAndStockAttributes
     */
    public function setStockItems(\StructType\StockItemForAddStockWithAttributesList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
}
