<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuRequestList StructType
 * @subpackage Structs
 */
class ProductSkuRequestList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSkuRequest[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductSkuRequestList
     * @uses ProductSkuRequestList::setStockItem()
     * @param \StructType\ProductSkuRequest[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSkuRequest[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemForArrayConstraintsFromSetStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSkuRequestListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuRequestListStockItemItem instanceof \StructType\ProductSkuRequest) {
                $invalidValues[] = is_object($productSkuRequestListStockItemItem) ? get_class($productSkuRequestListStockItemItem) : sprintf('%s(%s)', gettype($productSkuRequestListStockItemItem), var_export($productSkuRequestListStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItem property can only contain items of type \StructType\ProductSkuRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuRequest[] $stockItem
     * @return \StructType\ProductSkuRequestList
     */
    public function setStockItem(array $stockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemArrayErrorMessage = self::validateStockItemForArrayConstraintsFromSetStockItem($stockItem))) {
            throw new \InvalidArgumentException($stockItemArrayErrorMessage, __LINE__);
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuRequest $item
     * @return \StructType\ProductSkuRequestList
     */
    public function addToStockItem(\StructType\ProductSkuRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSkuRequest) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of type \StructType\ProductSkuRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
}
