<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuRequest StructType
 * @subpackage Structs
 */
class ProductSkuRequest extends AbstractStructBase
{
    /**
     * The bundle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $bundle;
    /**
     * The mpn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mpn;
    /**
     * The gtin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gtin;
    /**
     * The n11CatalogId
     * @var int
     */
    public $n11CatalogId;
    /**
     * The oem
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $oem;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The attributes
     * @var \StructType\ProductAttributeRequestList
     */
    public $attributes;
    /**
     * The optionPrice
     * @var float
     */
    public $optionPrice;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * Constructor method for ProductSkuRequest
     * @uses ProductSkuRequest::setBundle()
     * @uses ProductSkuRequest::setMpn()
     * @uses ProductSkuRequest::setGtin()
     * @uses ProductSkuRequest::setN11CatalogId()
     * @uses ProductSkuRequest::setOem()
     * @uses ProductSkuRequest::setQuantity()
     * @uses ProductSkuRequest::setSellerStockCode()
     * @uses ProductSkuRequest::setAttributes()
     * @uses ProductSkuRequest::setOptionPrice()
     * @uses ProductSkuRequest::setImages()
     * @param bool $bundle
     * @param string $mpn
     * @param string $gtin
     * @param int $n11CatalogId
     * @param string $oem
     * @param int $quantity
     * @param string $sellerStockCode
     * @param \StructType\ProductAttributeRequestList $attributes
     * @param float $optionPrice
     * @param \StructType\ProductImageList $images
     */
    public function __construct($bundle = null, $mpn = null, $gtin = null, $n11CatalogId = null, $oem = null, $quantity = null, $sellerStockCode = null, \StructType\ProductAttributeRequestList $attributes = null, $optionPrice = null, \StructType\ProductImageList $images = null)
    {
        $this
            ->setBundle($bundle)
            ->setMpn($mpn)
            ->setGtin($gtin)
            ->setN11CatalogId($n11CatalogId)
            ->setOem($oem)
            ->setQuantity($quantity)
            ->setSellerStockCode($sellerStockCode)
            ->setAttributes($attributes)
            ->setOptionPrice($optionPrice)
            ->setImages($images);
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\ProductSkuRequest
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundle, true), gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\ProductSkuRequest
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpn, true), gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductSkuRequest
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtin, true), gettype($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get n11CatalogId value
     * @return int|null
     */
    public function getN11CatalogId()
    {
        return $this->n11CatalogId;
    }
    /**
     * Set n11CatalogId value
     * @param int $n11CatalogId
     * @return \StructType\ProductSkuRequest
     */
    public function setN11CatalogId($n11CatalogId = null)
    {
        // validation for constraint: int
        if (!is_null($n11CatalogId) && !(is_int($n11CatalogId) || ctype_digit($n11CatalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($n11CatalogId, true), gettype($n11CatalogId)), __LINE__);
        }
        $this->n11CatalogId = $n11CatalogId;
        return $this;
    }
    /**
     * Get oem value
     * @return string|null
     */
    public function getOem()
    {
        return $this->oem;
    }
    /**
     * Set oem value
     * @param string $oem
     * @return \StructType\ProductSkuRequest
     */
    public function setOem($oem = null)
    {
        // validation for constraint: string
        if (!is_null($oem) && !is_string($oem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oem, true), gettype($oem)), __LINE__);
        }
        $this->oem = $oem;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ProductSkuRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductSkuRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStockCode, true), gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeRequestList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeRequestList $attributes
     * @return \StructType\ProductSkuRequest
     */
    public function setAttributes(\StructType\ProductAttributeRequestList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float|null
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\ProductSkuRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($optionPrice) && !(is_float($optionPrice) || is_numeric($optionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionPrice, true), gettype($optionPrice)), __LINE__);
        }
        $this->optionPrice = $optionPrice;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\ProductSkuRequest
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
}
