<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuList StructType
 * @subpackage Structs
 */
class ProductSkuList extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSku[]
     */
    public $stockItem;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * Constructor method for ProductSkuList
     * @uses ProductSkuList::setId()
     * @uses ProductSkuList::setStockItem()
     * @uses ProductSkuList::setProductSellerCode()
     * @param int $id
     * @param \StructType\ProductSku[] $stockItem
     * @param string $productSellerCode
     */
    public function __construct($id = null, array $stockItem = array(), $productSellerCode = null)
    {
        $this
            ->setId($id)
            ->setStockItem($stockItem)
            ->setProductSellerCode($productSellerCode);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductSkuList
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSku[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemForArrayConstraintsFromSetStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSkuListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuListStockItemItem instanceof \StructType\ProductSku) {
                $invalidValues[] = is_object($productSkuListStockItemItem) ? get_class($productSkuListStockItemItem) : sprintf('%s(%s)', gettype($productSkuListStockItemItem), var_export($productSkuListStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItem property can only contain items of type \StructType\ProductSku, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku[] $stockItem
     * @return \StructType\ProductSkuList
     */
    public function setStockItem(array $stockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemArrayErrorMessage = self::validateStockItemForArrayConstraintsFromSetStockItem($stockItem))) {
            throw new \InvalidArgumentException($stockItemArrayErrorMessage, __LINE__);
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku $item
     * @return \StructType\ProductSkuList
     */
    public function addToStockItem(\StructType\ProductSku $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSku) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of type \StructType\ProductSku, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductSkuList
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
}
