<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasic StructType
 * @subpackage Structs
 */
class ProductSkuBasic extends ProductSkuBasicRequest
{
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The oldOptionPrice
     * @var float
     */
    public $oldOptionPrice;
    /**
     * The gtin
     * @var string
     */
    public $gtin;
    /**
     * The n11CatalogId
     * @var int
     */
    public $n11CatalogId;
    /**
     * The mpn
     * @var string
     */
    public $mpn;
    /**
     * The oem
     * @var string
     */
    public $oem;
    /**
     * The bundle
     * @var bool
     */
    public $bundle;
    /**
     * Constructor method for ProductSkuBasic
     * @uses ProductSkuBasic::setCurrencyAmount()
     * @uses ProductSkuBasic::setDisplayPrice()
     * @uses ProductSkuBasic::setOldOptionPrice()
     * @uses ProductSkuBasic::setGtin()
     * @uses ProductSkuBasic::setN11CatalogId()
     * @uses ProductSkuBasic::setMpn()
     * @uses ProductSkuBasic::setOem()
     * @uses ProductSkuBasic::setBundle()
     * @param float $currencyAmount
     * @param float $displayPrice
     * @param float $oldOptionPrice
     * @param string $gtin
     * @param int $n11CatalogId
     * @param string $mpn
     * @param string $oem
     * @param bool $bundle
     */
    public function __construct($currencyAmount = null, $displayPrice = null, $oldOptionPrice = null, $gtin = null, $n11CatalogId = null, $mpn = null, $oem = null, $bundle = null)
    {
        $this
            ->setCurrencyAmount($currencyAmount)
            ->setDisplayPrice($displayPrice)
            ->setOldOptionPrice($oldOptionPrice)
            ->setGtin($gtin)
            ->setN11CatalogId($n11CatalogId)
            ->setMpn($mpn)
            ->setOem($oem)
            ->setBundle($bundle);
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\ProductSkuBasic
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($currencyAmount) && !(is_float($currencyAmount) || is_numeric($currencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyAmount, true), gettype($currencyAmount)), __LINE__);
        }
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\ProductSkuBasic
     */
    public function setDisplayPrice($displayPrice = null)
    {
        // validation for constraint: float
        if (!is_null($displayPrice) && !(is_float($displayPrice) || is_numeric($displayPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($displayPrice, true), gettype($displayPrice)), __LINE__);
        }
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get oldOptionPrice value
     * @return float|null
     */
    public function getOldOptionPrice()
    {
        return $this->oldOptionPrice;
    }
    /**
     * Set oldOptionPrice value
     * @param float $oldOptionPrice
     * @return \StructType\ProductSkuBasic
     */
    public function setOldOptionPrice($oldOptionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($oldOptionPrice) && !(is_float($oldOptionPrice) || is_numeric($oldOptionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oldOptionPrice, true), gettype($oldOptionPrice)), __LINE__);
        }
        $this->oldOptionPrice = $oldOptionPrice;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductSkuBasic
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtin, true), gettype($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get n11CatalogId value
     * @return int|null
     */
    public function getN11CatalogId()
    {
        return $this->n11CatalogId;
    }
    /**
     * Set n11CatalogId value
     * @param int $n11CatalogId
     * @return \StructType\ProductSkuBasic
     */
    public function setN11CatalogId($n11CatalogId = null)
    {
        // validation for constraint: int
        if (!is_null($n11CatalogId) && !(is_int($n11CatalogId) || ctype_digit($n11CatalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($n11CatalogId, true), gettype($n11CatalogId)), __LINE__);
        }
        $this->n11CatalogId = $n11CatalogId;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\ProductSkuBasic
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpn, true), gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get oem value
     * @return string|null
     */
    public function getOem()
    {
        return $this->oem;
    }
    /**
     * Set oem value
     * @param string $oem
     * @return \StructType\ProductSkuBasic
     */
    public function setOem($oem = null)
    {
        // validation for constraint: string
        if (!is_null($oem) && !is_string($oem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oem, true), gettype($oem)), __LINE__);
        }
        $this->oem = $oem;
        return $this;
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\ProductSkuBasic
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundle, true), gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
}
