<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestionDetail StructType
 * @subpackage Structs
 */
class ProductQuestionDetail extends AbstractStructBase
{
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The productTitle
     * @var string
     */
    public $productTitle;
    /**
     * The questionSubject
     * @var string
     */
    public $questionSubject;
    /**
     * The question
     * @var string
     */
    public $question;
    /**
     * The answer
     * @var string
     */
    public $answer;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The productStatus
     * @var string
     */
    public $productStatus;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The questionDate
     * @var string
     */
    public $questionDate;
    /**
     * The answeredDate
     * @var string
     */
    public $answeredDate;
    /**
     * The sellerExpose
     * @var string
     */
    public $sellerExpose;
    /**
     * The buyerExpose
     * @var string
     */
    public $buyerExpose;
    /**
     * The images
     * @var \StructType\ImageList
     */
    public $images;
    /**
     * Constructor method for ProductQuestionDetail
     * @uses ProductQuestionDetail::setProductId()
     * @uses ProductQuestionDetail::setProductTitle()
     * @uses ProductQuestionDetail::setQuestionSubject()
     * @uses ProductQuestionDetail::setQuestion()
     * @uses ProductQuestionDetail::setAnswer()
     * @uses ProductQuestionDetail::setFullName()
     * @uses ProductQuestionDetail::setEmail()
     * @uses ProductQuestionDetail::setProductStatus()
     * @uses ProductQuestionDetail::setStatus()
     * @uses ProductQuestionDetail::setQuestionDate()
     * @uses ProductQuestionDetail::setAnsweredDate()
     * @uses ProductQuestionDetail::setSellerExpose()
     * @uses ProductQuestionDetail::setBuyerExpose()
     * @uses ProductQuestionDetail::setImages()
     * @param int $productId
     * @param string $productTitle
     * @param string $questionSubject
     * @param string $question
     * @param string $answer
     * @param string $fullName
     * @param string $email
     * @param string $productStatus
     * @param string $status
     * @param string $questionDate
     * @param string $answeredDate
     * @param string $sellerExpose
     * @param string $buyerExpose
     * @param \StructType\ImageList $images
     */
    public function __construct($productId = null, $productTitle = null, $questionSubject = null, $question = null, $answer = null, $fullName = null, $email = null, $productStatus = null, $status = null, $questionDate = null, $answeredDate = null, $sellerExpose = null, $buyerExpose = null, \StructType\ImageList $images = null)
    {
        $this
            ->setProductId($productId)
            ->setProductTitle($productTitle)
            ->setQuestionSubject($questionSubject)
            ->setQuestion($question)
            ->setAnswer($answer)
            ->setFullName($fullName)
            ->setEmail($email)
            ->setProductStatus($productStatus)
            ->setStatus($status)
            ->setQuestionDate($questionDate)
            ->setAnsweredDate($answeredDate)
            ->setSellerExpose($sellerExpose)
            ->setBuyerExpose($buyerExpose)
            ->setImages($images);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductQuestionDetail
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\ProductQuestionDetail
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTitle, true), gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get questionSubject value
     * @return string|null
     */
    public function getQuestionSubject()
    {
        return $this->questionSubject;
    }
    /**
     * Set questionSubject value
     * @param string $questionSubject
     * @return \StructType\ProductQuestionDetail
     */
    public function setQuestionSubject($questionSubject = null)
    {
        // validation for constraint: string
        if (!is_null($questionSubject) && !is_string($questionSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionSubject, true), gettype($questionSubject)), __LINE__);
        }
        $this->questionSubject = $questionSubject;
        return $this;
    }
    /**
     * Get question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->question;
    }
    /**
     * Set question value
     * @param string $question
     * @return \StructType\ProductQuestionDetail
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question, true), gettype($question)), __LINE__);
        }
        $this->question = $question;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \StructType\ProductQuestionDetail
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\ProductQuestionDetail
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ProductQuestionDetail
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get productStatus value
     * @return string|null
     */
    public function getProductStatus()
    {
        return $this->productStatus;
    }
    /**
     * Set productStatus value
     * @param string $productStatus
     * @return \StructType\ProductQuestionDetail
     */
    public function setProductStatus($productStatus = null)
    {
        // validation for constraint: string
        if (!is_null($productStatus) && !is_string($productStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productStatus, true), gettype($productStatus)), __LINE__);
        }
        $this->productStatus = $productStatus;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ProductQuestionDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get questionDate value
     * @return string|null
     */
    public function getQuestionDate()
    {
        return $this->questionDate;
    }
    /**
     * Set questionDate value
     * @param string $questionDate
     * @return \StructType\ProductQuestionDetail
     */
    public function setQuestionDate($questionDate = null)
    {
        // validation for constraint: string
        if (!is_null($questionDate) && !is_string($questionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionDate, true), gettype($questionDate)), __LINE__);
        }
        $this->questionDate = $questionDate;
        return $this;
    }
    /**
     * Get answeredDate value
     * @return string|null
     */
    public function getAnsweredDate()
    {
        return $this->answeredDate;
    }
    /**
     * Set answeredDate value
     * @param string $answeredDate
     * @return \StructType\ProductQuestionDetail
     */
    public function setAnsweredDate($answeredDate = null)
    {
        // validation for constraint: string
        if (!is_null($answeredDate) && !is_string($answeredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answeredDate, true), gettype($answeredDate)), __LINE__);
        }
        $this->answeredDate = $answeredDate;
        return $this;
    }
    /**
     * Get sellerExpose value
     * @return string|null
     */
    public function getSellerExpose()
    {
        return $this->sellerExpose;
    }
    /**
     * Set sellerExpose value
     * @param string $sellerExpose
     * @return \StructType\ProductQuestionDetail
     */
    public function setSellerExpose($sellerExpose = null)
    {
        // validation for constraint: string
        if (!is_null($sellerExpose) && !is_string($sellerExpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerExpose, true), gettype($sellerExpose)), __LINE__);
        }
        $this->sellerExpose = $sellerExpose;
        return $this;
    }
    /**
     * Get buyerExpose value
     * @return string|null
     */
    public function getBuyerExpose()
    {
        return $this->buyerExpose;
    }
    /**
     * Set buyerExpose value
     * @param string $buyerExpose
     * @return \StructType\ProductQuestionDetail
     */
    public function setBuyerExpose($buyerExpose = null)
    {
        // validation for constraint: string
        if (!is_null($buyerExpose) && !is_string($buyerExpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerExpose, true), gettype($buyerExpose)), __LINE__);
        }
        $this->buyerExpose = $buyerExpose;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ImageList $images
     * @return \StructType\ProductQuestionDetail
     */
    public function setImages(\StructType\ImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
}
