<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductImageList StructType
 * @subpackage Structs
 */
class ProductImageList extends AbstractStructBase
{
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductImage[]
     */
    public $image;
    /**
     * Constructor method for ProductImageList
     * @uses ProductImageList::setImage()
     * @param \StructType\ProductImage[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get image value
     * @return \StructType\ProductImage[]|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * This method is responsible for validating the values passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageForArrayConstraintsFromSetImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productImageListImageItem) {
            // validation for constraint: itemType
            if (!$productImageListImageItem instanceof \StructType\ProductImage) {
                $invalidValues[] = is_object($productImageListImageItem) ? get_class($productImageListImageItem) : sprintf('%s(%s)', gettype($productImageListImageItem), var_export($productImageListImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The image property can only contain items of type \StructType\ProductImage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set image value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductImage[] $image
     * @return \StructType\ProductImageList
     */
    public function setImage(array $image = array())
    {
        // validation for constraint: array
        if ('' !== ($imageArrayErrorMessage = self::validateImageForArrayConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageArrayErrorMessage, __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Add item to image value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductImage $item
     * @return \StructType\ProductImageList
     */
    public function addToImage(\StructType\ProductImage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductImage) {
            throw new \InvalidArgumentException(sprintf('The image property can only contain items of type \StructType\ProductImage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->image[] = $item;
        return $this;
    }
}
