<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductApprovalStatusResponse StructType
 * @subpackage Structs
 */
class ProductApprovalStatusResponse extends AbstractStructBase
{
    /**
     * The result
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductApprovalStatusApi[]
     */
    public $result;
    /**
     * Constructor method for ProductApprovalStatusResponse
     * @uses ProductApprovalStatusResponse::setResult()
     * @param \StructType\ProductApprovalStatusApi[] $result
     */
    public function __construct(array $result = array())
    {
        $this
            ->setResult($result);
    }
    /**
     * Get result value
     * @return \StructType\ProductApprovalStatusApi[]|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * This method is responsible for validating the values passed to the setResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultForArrayConstraintsFromSetResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productApprovalStatusResponseResultItem) {
            // validation for constraint: itemType
            if (!$productApprovalStatusResponseResultItem instanceof \StructType\ProductApprovalStatusApi) {
                $invalidValues[] = is_object($productApprovalStatusResponseResultItem) ? get_class($productApprovalStatusResponseResultItem) : sprintf('%s(%s)', gettype($productApprovalStatusResponseResultItem), var_export($productApprovalStatusResponseResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The result property can only contain items of type \StructType\ProductApprovalStatusApi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set result value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductApprovalStatusApi[] $result
     * @return \StructType\ProductApprovalStatusResponse
     */
    public function setResult(array $result = array())
    {
        // validation for constraint: array
        if ('' !== ($resultArrayErrorMessage = self::validateResultForArrayConstraintsFromSetResult($result))) {
            throw new \InvalidArgumentException($resultArrayErrorMessage, __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductApprovalStatusApi $item
     * @return \StructType\ProductApprovalStatusResponse
     */
    public function addToResult(\StructType\ProductApprovalStatusApi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductApprovalStatusApi) {
            throw new \InvalidArgumentException(sprintf('The result property can only contain items of type \StructType\ProductApprovalStatusApi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->result[] = $item;
        return $this;
    }
}
