<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The category
     * @var \StructType\Category
     */
    public $category;
    /**
     * The specialProductInfoList
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpecialProductInfoList
     */
    public $specialProductInfoList;
    /**
     * The preparingDay
     * @var int
     */
    public $preparingDay;
    /**
     * The productCondition
     * @var string
     */
    public $productCondition;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * The stockItems
     * @var \StructType\ProductSkuList
     */
    public $stockItems;
    /**
     * The discount
     * @var \StructType\ProductDiscount
     */
    public $discount;
    /**
     * The shipmentTemplate
     * @var string
     */
    public $shipmentTemplate;
    /**
     * The groupAttribute
     * @var string
     */
    public $groupAttribute;
    /**
     * The groupItemCode
     * @var string
     */
    public $groupItemCode;
    /**
     * The itemName
     * @var string
     */
    public $itemName;
    /**
     * The attributes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ProductAttributeList
     */
    public $attributes;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The saleStatus
     * @var int
     */
    public $saleStatus;
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * The unitInfo
     * @var \StructType\ProductUnitInfoModel
     */
    public $unitInfo;
    /**
     * The maxPurchaseQuantity
     * @var int
     */
    public $maxPurchaseQuantity;
    /**
     * The productStatusDetail
     * @var string
     */
    public $productStatusDetail;
    /**
     * The sellerNote
     * @var string
     */
    public $sellerNote;
    /**
     * Constructor method for Product
     * @uses Product::setId()
     * @uses Product::setTitle()
     * @uses Product::setDisplayPrice()
     * @uses Product::setPrice()
     * @uses Product::setProductSellerCode()
     * @uses Product::setDescription()
     * @uses Product::setCategory()
     * @uses Product::setSpecialProductInfoList()
     * @uses Product::setPreparingDay()
     * @uses Product::setProductCondition()
     * @uses Product::setExpirationDate()
     * @uses Product::setImages()
     * @uses Product::setStockItems()
     * @uses Product::setDiscount()
     * @uses Product::setShipmentTemplate()
     * @uses Product::setGroupAttribute()
     * @uses Product::setGroupItemCode()
     * @uses Product::setItemName()
     * @uses Product::setAttributes()
     * @uses Product::setApprovalStatus()
     * @uses Product::setSaleStatus()
     * @uses Product::setCurrencyAmount()
     * @uses Product::setCurrencyType()
     * @uses Product::setUnitInfo()
     * @uses Product::setMaxPurchaseQuantity()
     * @uses Product::setProductStatusDetail()
     * @uses Product::setSellerNote()
     * @param int $id
     * @param string $title
     * @param float $displayPrice
     * @param float $price
     * @param string $productSellerCode
     * @param string $description
     * @param \StructType\Category $category
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @param int $preparingDay
     * @param string $productCondition
     * @param string $expirationDate
     * @param \StructType\ProductImageList $images
     * @param \StructType\ProductSkuList $stockItems
     * @param \StructType\ProductDiscount $discount
     * @param string $shipmentTemplate
     * @param string $groupAttribute
     * @param string $groupItemCode
     * @param string $itemName
     * @param \StructType\ProductAttributeList $attributes
     * @param int $approvalStatus
     * @param int $saleStatus
     * @param float $currencyAmount
     * @param int $currencyType
     * @param \StructType\ProductUnitInfoModel $unitInfo
     * @param int $maxPurchaseQuantity
     * @param string $productStatusDetail
     * @param string $sellerNote
     */
    public function __construct($id = null, $title = null, $displayPrice = null, $price = null, $productSellerCode = null, $description = null, \StructType\Category $category = null, \StructType\SpecialProductInfoList $specialProductInfoList = null, $preparingDay = null, $productCondition = null, $expirationDate = null, \StructType\ProductImageList $images = null, \StructType\ProductSkuList $stockItems = null, \StructType\ProductDiscount $discount = null, $shipmentTemplate = null, $groupAttribute = null, $groupItemCode = null, $itemName = null, \StructType\ProductAttributeList $attributes = null, $approvalStatus = null, $saleStatus = null, $currencyAmount = null, $currencyType = null, \StructType\ProductUnitInfoModel $unitInfo = null, $maxPurchaseQuantity = null, $productStatusDetail = null, $sellerNote = null)
    {
        $this
            ->setId($id)
            ->setTitle($title)
            ->setDisplayPrice($displayPrice)
            ->setPrice($price)
            ->setProductSellerCode($productSellerCode)
            ->setDescription($description)
            ->setCategory($category)
            ->setSpecialProductInfoList($specialProductInfoList)
            ->setPreparingDay($preparingDay)
            ->setProductCondition($productCondition)
            ->setExpirationDate($expirationDate)
            ->setImages($images)
            ->setStockItems($stockItems)
            ->setDiscount($discount)
            ->setShipmentTemplate($shipmentTemplate)
            ->setGroupAttribute($groupAttribute)
            ->setGroupItemCode($groupItemCode)
            ->setItemName($itemName)
            ->setAttributes($attributes)
            ->setApprovalStatus($approvalStatus)
            ->setSaleStatus($saleStatus)
            ->setCurrencyAmount($currencyAmount)
            ->setCurrencyType($currencyType)
            ->setUnitInfo($unitInfo)
            ->setMaxPurchaseQuantity($maxPurchaseQuantity)
            ->setProductStatusDetail($productStatusDetail)
            ->setSellerNote($sellerNote);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Product
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Product
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\Product
     */
    public function setDisplayPrice($displayPrice = null)
    {
        // validation for constraint: float
        if (!is_null($displayPrice) && !(is_float($displayPrice) || is_numeric($displayPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($displayPrice, true), gettype($displayPrice)), __LINE__);
        }
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\Product
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\Product
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\Category|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\Category $category
     * @return \StructType\Product
     */
    public function setCategory(\StructType\Category $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get specialProductInfoList value
     * @return \StructType\SpecialProductInfoList|null
     */
    public function getSpecialProductInfoList()
    {
        return $this->specialProductInfoList;
    }
    /**
     * Set specialProductInfoList value
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @return \StructType\Product
     */
    public function setSpecialProductInfoList(\StructType\SpecialProductInfoList $specialProductInfoList = null)
    {
        $this->specialProductInfoList = $specialProductInfoList;
        return $this;
    }
    /**
     * Get preparingDay value
     * @return int|null
     */
    public function getPreparingDay()
    {
        return $this->preparingDay;
    }
    /**
     * Set preparingDay value
     * @param int $preparingDay
     * @return \StructType\Product
     */
    public function setPreparingDay($preparingDay = null)
    {
        // validation for constraint: int
        if (!is_null($preparingDay) && !(is_int($preparingDay) || ctype_digit($preparingDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preparingDay, true), gettype($preparingDay)), __LINE__);
        }
        $this->preparingDay = $preparingDay;
        return $this;
    }
    /**
     * Get productCondition value
     * @return string|null
     */
    public function getProductCondition()
    {
        return $this->productCondition;
    }
    /**
     * Set productCondition value
     * @param string $productCondition
     * @return \StructType\Product
     */
    public function setProductCondition($productCondition = null)
    {
        // validation for constraint: string
        if (!is_null($productCondition) && !is_string($productCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCondition, true), gettype($productCondition)), __LINE__);
        }
        $this->productCondition = $productCondition;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\Product
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\Product
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuList $stockItems
     * @return \StructType\Product
     */
    public function setStockItems(\StructType\ProductSkuList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\ProductDiscount|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\ProductDiscount $discount
     * @return \StructType\Product
     */
    public function setDiscount(\StructType\ProductDiscount $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get shipmentTemplate value
     * @return string|null
     */
    public function getShipmentTemplate()
    {
        return $this->shipmentTemplate;
    }
    /**
     * Set shipmentTemplate value
     * @param string $shipmentTemplate
     * @return \StructType\Product
     */
    public function setShipmentTemplate($shipmentTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTemplate) && !is_string($shipmentTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentTemplate, true), gettype($shipmentTemplate)), __LINE__);
        }
        $this->shipmentTemplate = $shipmentTemplate;
        return $this;
    }
    /**
     * Get groupAttribute value
     * @return string|null
     */
    public function getGroupAttribute()
    {
        return $this->groupAttribute;
    }
    /**
     * Set groupAttribute value
     * @param string $groupAttribute
     * @return \StructType\Product
     */
    public function setGroupAttribute($groupAttribute = null)
    {
        // validation for constraint: string
        if (!is_null($groupAttribute) && !is_string($groupAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupAttribute, true), gettype($groupAttribute)), __LINE__);
        }
        $this->groupAttribute = $groupAttribute;
        return $this;
    }
    /**
     * Get groupItemCode value
     * @return string|null
     */
    public function getGroupItemCode()
    {
        return $this->groupItemCode;
    }
    /**
     * Set groupItemCode value
     * @param string $groupItemCode
     * @return \StructType\Product
     */
    public function setGroupItemCode($groupItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupItemCode) && !is_string($groupItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupItemCode, true), gettype($groupItemCode)), __LINE__);
        }
        $this->groupItemCode = $groupItemCode;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\Product
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeList $attributes
     * @return \StructType\Product
     */
    public function setAttributes(\StructType\ProductAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\Product
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !(is_int($approvalStatus) || ctype_digit($approvalStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($approvalStatus, true), gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get saleStatus value
     * @return int|null
     */
    public function getSaleStatus()
    {
        return $this->saleStatus;
    }
    /**
     * Set saleStatus value
     * @param int $saleStatus
     * @return \StructType\Product
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: int
        if (!is_null($saleStatus) && !(is_int($saleStatus) || ctype_digit($saleStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleStatus, true), gettype($saleStatus)), __LINE__);
        }
        $this->saleStatus = $saleStatus;
        return $this;
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\Product
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($currencyAmount) && !(is_float($currencyAmount) || is_numeric($currencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyAmount, true), gettype($currencyAmount)), __LINE__);
        }
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\Product
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !(is_int($currencyType) || ctype_digit($currencyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyType, true), gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Get unitInfo value
     * @return \StructType\ProductUnitInfoModel|null
     */
    public function getUnitInfo()
    {
        return $this->unitInfo;
    }
    /**
     * Set unitInfo value
     * @param \StructType\ProductUnitInfoModel $unitInfo
     * @return \StructType\Product
     */
    public function setUnitInfo(\StructType\ProductUnitInfoModel $unitInfo = null)
    {
        $this->unitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get maxPurchaseQuantity value
     * @return int|null
     */
    public function getMaxPurchaseQuantity()
    {
        return $this->maxPurchaseQuantity;
    }
    /**
     * Set maxPurchaseQuantity value
     * @param int $maxPurchaseQuantity
     * @return \StructType\Product
     */
    public function setMaxPurchaseQuantity($maxPurchaseQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxPurchaseQuantity) && !(is_int($maxPurchaseQuantity) || ctype_digit($maxPurchaseQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPurchaseQuantity, true), gettype($maxPurchaseQuantity)), __LINE__);
        }
        $this->maxPurchaseQuantity = $maxPurchaseQuantity;
        return $this;
    }
    /**
     * Get productStatusDetail value
     * @return string|null
     */
    public function getProductStatusDetail()
    {
        return $this->productStatusDetail;
    }
    /**
     * Set productStatusDetail value
     * @param string $productStatusDetail
     * @return \StructType\Product
     */
    public function setProductStatusDetail($productStatusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($productStatusDetail) && !is_string($productStatusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productStatusDetail, true), gettype($productStatusDetail)), __LINE__);
        }
        $this->productStatusDetail = $productStatusDetail;
        return $this;
    }
    /**
     * Get sellerNote value
     * @return string|null
     */
    public function getSellerNote()
    {
        return $this->sellerNote;
    }
    /**
     * Set sellerNote value
     * @param string $sellerNote
     * @return \StructType\Product
     */
    public function setSellerNote($sellerNote = null)
    {
        // validation for constraint: string
        if (!is_null($sellerNote) && !is_string($sellerNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerNote, true), gettype($sellerNote)), __LINE__);
        }
        $this->sellerNote = $sellerNote;
        return $this;
    }
}
