<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductQuestionDetailRequest StructType
 * @subpackage Structs
 */
class GetProductQuestionDetailRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productQuestionId
     * @var int
     */
    public $productQuestionId;
    /**
     * Constructor method for GetProductQuestionDetailRequest
     * @uses GetProductQuestionDetailRequest::setAuth()
     * @uses GetProductQuestionDetailRequest::setProductQuestionId()
     * @param \StructType\Authentication $auth
     * @param int $productQuestionId
     */
    public function __construct(\StructType\Authentication $auth = null, $productQuestionId = null)
    {
        $this
            ->setAuth($auth)
            ->setProductQuestionId($productQuestionId);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductQuestionDetailRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productQuestionId value
     * @return int|null
     */
    public function getProductQuestionId()
    {
        return $this->productQuestionId;
    }
    /**
     * Set productQuestionId value
     * @param int $productQuestionId
     * @return \StructType\GetProductQuestionDetailRequest
     */
    public function setProductQuestionId($productQuestionId = null)
    {
        // validation for constraint: int
        if (!is_null($productQuestionId) && !(is_int($productQuestionId) || ctype_digit($productQuestionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productQuestionId, true), gettype($productQuestionId)), __LINE__);
        }
        $this->productQuestionId = $productQuestionId;
        return $this;
    }
}
