<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductBySellerCodeRequest StructType
 * @subpackage Structs
 */
class GetProductBySellerCodeRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The sellerCode
     * @var string
     */
    public $sellerCode;
    /**
     * Constructor method for GetProductBySellerCodeRequest
     * @uses GetProductBySellerCodeRequest::setAuth()
     * @uses GetProductBySellerCodeRequest::setSellerCode()
     * @param \StructType\Authentication $auth
     * @param string $sellerCode
     */
    public function __construct(\StructType\Authentication $auth = null, $sellerCode = null)
    {
        $this
            ->setAuth($auth)
            ->setSellerCode($sellerCode);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductBySellerCodeRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \StructType\GetProductBySellerCodeRequest
     */
    public function setSellerCode($sellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerCode) && !is_string($sellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerCode, true), gettype($sellerCode)), __LINE__);
        }
        $this->sellerCode = $sellerCode;
        return $this;
    }
}
