<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetProductList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductListRequest $getProductListRequest
     * @return \StructType\GetProductListResponse|bool
     */
    public function GetProductList(\StructType\GetProductListRequest $getProductListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductList($getProductListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductBySellerCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductBySellerCodeRequest $getProductBySellerCodeRequest
     * @return \StructType\GetProductBySellerCodeResponse|bool
     */
    public function GetProductBySellerCode(\StructType\GetProductBySellerCodeRequest $getProductBySellerCodeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductBySellerCode($getProductBySellerCodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductQuestionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductQuestionListRequest $getProductQuestionListRequest
     * @return \StructType\GetProductQuestionListResponse|bool
     */
    public function GetProductQuestionList(\StructType\GetProductQuestionListRequest $getProductQuestionListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductQuestionList($getProductQuestionListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductQuestionDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductQuestionDetailRequest $getProductQuestionDetailRequest
     * @return \StructType\GetProductQuestionDetailResponse|bool
     */
    public function GetProductQuestionDetail(\StructType\GetProductQuestionDetailRequest $getProductQuestionDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductQuestionDetail($getProductQuestionDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductByProductId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductByProductIdRequest $getProductByProductIdRequest
     * @return \StructType\GetProductByProductIdResponse|bool
     */
    public function GetProductByProductId(\StructType\GetProductByProductIdRequest $getProductByProductIdRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductByProductId($getProductByProductIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetProductByProductIdResponse|\StructType\GetProductBySellerCodeResponse|\StructType\GetProductListResponse|\StructType\GetProductQuestionDetailResponse|\StructType\GetProductQuestionListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
