<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.n11.com/ws/ProductService.wsdl?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.n11.com/ws/ProductService.wsdl?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetProductList operation/method
 */
if ($get->GetProductList(new \StructType\GetProductListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductBySellerCode operation/method
 */
if ($get->GetProductBySellerCode(new \StructType\GetProductBySellerCodeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductQuestionList operation/method
 */
if ($get->GetProductQuestionList(new \StructType\GetProductQuestionListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductQuestionDetail operation/method
 */
if ($get->GetProductQuestionDetail(new \StructType\GetProductQuestionDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductByProductId operation/method
 */
if ($get->GetProductByProductId(new \StructType\GetProductByProductIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateProductPriceBySellerCode operation/method
 */
if ($update->UpdateProductPriceBySellerCode(new \StructType\UpdateProductPriceBySellerCodeRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDiscountValueBySellerCode operation/method
 */
if ($update->UpdateDiscountValueBySellerCode(new \StructType\UpdateDiscountValueBySellerCodeRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateProductBasic operation/method
 */
if ($update->UpdateProductBasic(new \StructType\UpdateProductBasicRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDiscountValueByProductId operation/method
 */
if ($update->UpdateDiscountValueByProductId(new \StructType\UpdateDiscountValueByProductIdRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateProductPriceById operation/method
 */
if ($update->UpdateProductPriceById(new \StructType\UpdateProductPriceByIdRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteProductById operation/method
 */
if ($delete->DeleteProductById(new \StructType\DeleteProductByIdRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteProductBySellerCode operation/method
 */
if ($delete->DeleteProductBySellerCode(new \StructType\DeleteProductBySellerCodeRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveProductAnswer operation/method
 */
if ($save->SaveProductAnswer(new \StructType\SaveProductAnswerRequest()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveProduct operation/method
 */
if ($save->SaveProduct(new \StructType\SaveProductRequest()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchProducts operation/method
 */
if ($search->SearchProducts(new \StructType\SearchProductsRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Adapt ServiceType
 */
$adapt = new \ServiceType\Adapt($options);
/**
 * Sample call for AdaptUnificationProducts operation/method
 */
if ($adapt->AdaptUnificationProducts(new \StructType\AdaptUnificationProductsRequest()) !== false) {
    print_r($adapt->getResult());
} else {
    print_r($adapt->getLastError());
}
/**
 * Samples for Product ServiceType
 */
$product = new \ServiceType\Product($options);
/**
 * Sample call for ProductApprovalStatus operation/method
 */
if ($product->ProductApprovalStatus(new \StructType\ProductApprovalStatusRequest()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
