<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithSellerStockCode StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithSellerStockCode extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The quantityToIncrease
     * @var int
     */
    public $quantityToIncrease;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForAddStockWithSellerStockCode
     * @uses StockItemForAddStockWithSellerStockCode::setSellerStockCode()
     * @uses StockItemForAddStockWithSellerStockCode::setQuantityToIncrease()
     * @uses StockItemForAddStockWithSellerStockCode::setVersion()
     * @param string $sellerStockCode
     * @param int $quantityToIncrease
     * @param int $version
     */
    public function __construct($sellerStockCode = null, $quantityToIncrease = null, $version = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setQuantityToIncrease($quantityToIncrease)
            ->setVersion($version);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStockCode, true), gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get quantityToIncrease value
     * @return int|null
     */
    public function getQuantityToIncrease()
    {
        return $this->quantityToIncrease;
    }
    /**
     * Set quantityToIncrease value
     * @param int $quantityToIncrease
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setQuantityToIncrease($quantityToIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($quantityToIncrease) && !(is_int($quantityToIncrease) || ctype_digit($quantityToIncrease))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityToIncrease, true), gettype($quantityToIncrease)), __LINE__);
        }
        $this->quantityToIncrease = $quantityToIncrease;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
