<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithId StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithId extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The quantityToIncrease
     * @var int
     */
    public $quantityToIncrease;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForAddStockWithId
     * @uses StockItemForAddStockWithId::setId()
     * @uses StockItemForAddStockWithId::setQuantityToIncrease()
     * @uses StockItemForAddStockWithId::setVersion()
     * @param int $id
     * @param int $quantityToIncrease
     * @param int $version
     */
    public function __construct($id = null, $quantityToIncrease = null, $version = null)
    {
        $this
            ->setId($id)
            ->setQuantityToIncrease($quantityToIncrease)
            ->setVersion($version);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\StockItemForAddStockWithId
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get quantityToIncrease value
     * @return int|null
     */
    public function getQuantityToIncrease()
    {
        return $this->quantityToIncrease;
    }
    /**
     * Set quantityToIncrease value
     * @param int $quantityToIncrease
     * @return \StructType\StockItemForAddStockWithId
     */
    public function setQuantityToIncrease($quantityToIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($quantityToIncrease) && !(is_int($quantityToIncrease) || ctype_digit($quantityToIncrease))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityToIncrease, true), gettype($quantityToIncrease)), __LINE__);
        }
        $this->quantityToIncrease = $quantityToIncrease;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForAddStockWithId
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
