<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveProductRequest StructType
 * @subpackage Structs
 */
class SaveProductRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The product
     * @var \StructType\ProductRequest
     */
    public $product;
    /**
     * Constructor method for SaveProductRequest
     * @uses SaveProductRequest::setAuth()
     * @uses SaveProductRequest::setProduct()
     * @param \StructType\Authentication $auth
     * @param \StructType\ProductRequest $product
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\ProductRequest $product = null)
    {
        $this
            ->setAuth($auth)
            ->setProduct($product);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SaveProductRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\ProductRequest|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductRequest $product
     * @return \StructType\SaveProductRequest
     */
    public function setProduct(\StructType\ProductRequest $product = null)
    {
        $this->product = $product;
        return $this;
    }
}
