<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductIdList StructType
 * @subpackage Structs
 */
class ProductIdList extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $productId;
    /**
     * Constructor method for ProductIdList
     * @uses ProductIdList::setProductId()
     * @param int[] $productId
     */
    public function __construct(array $productId = array())
    {
        $this
            ->setProductId($productId);
    }
    /**
     * Get productId value
     * @return int[]|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * This method is responsible for validating the values passed to the setProductId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductIdForArrayConstraintsFromSetProductId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productIdListProductIdItem) {
            // validation for constraint: itemType
            if (!(is_int($productIdListProductIdItem) || ctype_digit($productIdListProductIdItem))) {
                $invalidValues[] = is_object($productIdListProductIdItem) ? get_class($productIdListProductIdItem) : sprintf('%s(%s)', gettype($productIdListProductIdItem), var_export($productIdListProductIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productId property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productId value
     * @throws \InvalidArgumentException
     * @param int[] $productId
     * @return \StructType\ProductIdList
     */
    public function setProductId(array $productId = array())
    {
        // validation for constraint: array
        if ('' !== ($productIdArrayErrorMessage = self::validateProductIdForArrayConstraintsFromSetProductId($productId))) {
            throw new \InvalidArgumentException($productIdArrayErrorMessage, __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Add item to productId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ProductIdList
     */
    public function addToProductId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The productId property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productId[] = $item;
        return $this;
    }
}
