<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductData StructType
 * @subpackage Structs
 */
class ProductData extends AbstractStructBase
{
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * The producedDate
     * @var string
     */
    public $producedDate;
    /**
     * The expireDate
     * @var string
     */
    public $expireDate;
    /**
     * The saleEndDate
     * @var string
     */
    public $saleEndDate;
    /**
     * The saleStartDate
     * @var string
     */
    public $saleStartDate;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The maxPurchaseQuantity
     * @var int
     */
    public $maxPurchaseQuantity;
    /**
     * Constructor method for ProductData
     * @uses ProductData::setVersion()
     * @uses ProductData::setProducedDate()
     * @uses ProductData::setExpireDate()
     * @uses ProductData::setSaleEndDate()
     * @uses ProductData::setSaleStartDate()
     * @uses ProductData::setDescription()
     * @uses ProductData::setPrice()
     * @uses ProductData::setMaxPurchaseQuantity()
     * @param int $version
     * @param string $producedDate
     * @param string $expireDate
     * @param string $saleEndDate
     * @param string $saleStartDate
     * @param string $description
     * @param float $price
     * @param int $maxPurchaseQuantity
     */
    public function __construct($version = null, $producedDate = null, $expireDate = null, $saleEndDate = null, $saleStartDate = null, $description = null, $price = null, $maxPurchaseQuantity = null)
    {
        $this
            ->setVersion($version)
            ->setProducedDate($producedDate)
            ->setExpireDate($expireDate)
            ->setSaleEndDate($saleEndDate)
            ->setSaleStartDate($saleStartDate)
            ->setDescription($description)
            ->setPrice($price)
            ->setMaxPurchaseQuantity($maxPurchaseQuantity);
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\ProductData
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get producedDate value
     * @return string|null
     */
    public function getProducedDate()
    {
        return $this->producedDate;
    }
    /**
     * Set producedDate value
     * @param string $producedDate
     * @return \StructType\ProductData
     */
    public function setProducedDate($producedDate = null)
    {
        // validation for constraint: string
        if (!is_null($producedDate) && !is_string($producedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producedDate, true), gettype($producedDate)), __LINE__);
        }
        $this->producedDate = $producedDate;
        return $this;
    }
    /**
     * Get expireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->expireDate;
    }
    /**
     * Set expireDate value
     * @param string $expireDate
     * @return \StructType\ProductData
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->expireDate = $expireDate;
        return $this;
    }
    /**
     * Get saleEndDate value
     * @return string|null
     */
    public function getSaleEndDate()
    {
        return $this->saleEndDate;
    }
    /**
     * Set saleEndDate value
     * @param string $saleEndDate
     * @return \StructType\ProductData
     */
    public function setSaleEndDate($saleEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleEndDate) && !is_string($saleEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleEndDate, true), gettype($saleEndDate)), __LINE__);
        }
        $this->saleEndDate = $saleEndDate;
        return $this;
    }
    /**
     * Get saleStartDate value
     * @return string|null
     */
    public function getSaleStartDate()
    {
        return $this->saleStartDate;
    }
    /**
     * Set saleStartDate value
     * @param string $saleStartDate
     * @return \StructType\ProductData
     */
    public function setSaleStartDate($saleStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleStartDate) && !is_string($saleStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleStartDate, true), gettype($saleStartDate)), __LINE__);
        }
        $this->saleStartDate = $saleStartDate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProductData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get maxPurchaseQuantity value
     * @return int|null
     */
    public function getMaxPurchaseQuantity()
    {
        return $this->maxPurchaseQuantity;
    }
    /**
     * Set maxPurchaseQuantity value
     * @param int $maxPurchaseQuantity
     * @return \StructType\ProductData
     */
    public function setMaxPurchaseQuantity($maxPurchaseQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxPurchaseQuantity) && !(is_int($maxPurchaseQuantity) || ctype_digit($maxPurchaseQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPurchaseQuantity, true), gettype($maxPurchaseQuantity)), __LINE__);
        }
        $this->maxPurchaseQuantity = $maxPurchaseQuantity;
        return $this;
    }
}
