<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductByProductIdRequest StructType
 * @subpackage Structs
 */
class GetProductByProductIdRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * Constructor method for GetProductByProductIdRequest
     * @uses GetProductByProductIdRequest::setAuth()
     * @uses GetProductByProductIdRequest::setProductId()
     * @param \StructType\Authentication $auth
     * @param int $productId
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductByProductIdRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\GetProductByProductIdRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
}
