<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSUserCredentials Struct
 * Meta information extracted from the WSDL
 * - documentation: Login information to YourGLS
 * @subpackage Structs
 */
class GLSUserCredentials extends AbstractStructBase
{
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GLSUserCredentials
     * @uses GLSUserCredentials::setUserName()
     * @uses GLSUserCredentials::setPassword()
     * @param string $userName
     * @param string $password
     */
    public function __construct($userName = null, $password = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get UserName value
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \GlsApi\Struct\GLSUserCredentials
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \GlsApi\Struct\GLSUserCredentials
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
