<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsReponseType Struct
 * @subpackage Structs
 */
class TusDetailsReponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TusDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\Struct\TuDetailsResponseType[]
     */
    public $TusDetails;
    /**
     * Constructor method for TusDetailsReponseType
     * @uses TusDetailsReponseType::setExitCode()
     * @uses TusDetailsReponseType::setTusDetails()
     * @param \GlsApi\Struct\GLSExitCode $exitCode
     * @param \GlsApi\Struct\TuDetailsResponseType[] $tusDetails
     */
    public function __construct(\GlsApi\Struct\GLSExitCode $exitCode = null, array $tusDetails = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTusDetails($tusDetails);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\Struct\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\Struct\GLSExitCode $exitCode
     * @return \GlsApi\Struct\TusDetailsReponseType
     */
    public function setExitCode(\GlsApi\Struct\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TusDetails value
     * @return \GlsApi\Struct\TuDetailsResponseType[]|null
     */
    public function getTusDetails()
    {
        return $this->TusDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setTusDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTusDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTusDetailsForArrayConstraintsFromSetTusDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tusDetailsReponseTypeTusDetailsItem) {
            // validation for constraint: itemType
            if (!$tusDetailsReponseTypeTusDetailsItem instanceof \GlsApi\Struct\TuDetailsResponseType) {
                $invalidValues[] = is_object($tusDetailsReponseTypeTusDetailsItem) ? get_class($tusDetailsReponseTypeTusDetailsItem) : sprintf('%s(%s)', gettype($tusDetailsReponseTypeTusDetailsItem), var_export($tusDetailsReponseTypeTusDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TusDetails property can only contain items of type \GlsApi\Struct\TuDetailsResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TusDetails value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\TuDetailsResponseType[] $tusDetails
     * @return \GlsApi\Struct\TusDetailsReponseType
     */
    public function setTusDetails(array $tusDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($tusDetailsArrayErrorMessage = self::validateTusDetailsForArrayConstraintsFromSetTusDetails($tusDetails))) {
            throw new \InvalidArgumentException($tusDetailsArrayErrorMessage, __LINE__);
        }
        $this->TusDetails = $tusDetails;
        return $this;
    }
    /**
     * Add item to TusDetails value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\TuDetailsResponseType $item
     * @return \GlsApi\Struct\TusDetailsReponseType
     */
    public function addToTusDetails(\GlsApi\Struct\TuDetailsResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\TuDetailsResponseType) {
            throw new \InvalidArgumentException(sprintf('The TusDetails property can only contain items of type \GlsApi\Struct\TuDetailsResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TusDetails[] = $item;
        return $this;
    }
}
