<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListRequestType Struct
 * @subpackage Structs
 */
class TuListRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefValue;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsApi\Struct\GLSDateTime
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsApi\Struct\GLSDateTime
     */
    public $DateTo;
    /**
     * The CustomRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomRef;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\Struct\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuListRequestType
     * @uses TuListRequestType::setCredentials()
     * @uses TuListRequestType::setRefValue()
     * @uses TuListRequestType::setDateFrom()
     * @uses TuListRequestType::setDateTo()
     * @uses TuListRequestType::setCustomRef()
     * @uses TuListRequestType::setParameters()
     * @param \GlsApi\Struct\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \GlsApi\Struct\GLSDateTime $dateFrom
     * @param \GlsApi\Struct\GLSDateTime $dateTo
     * @param string $customRef
     * @param \GlsApi\Struct\GLSParameters[] $parameters
     */
    public function __construct(\GlsApi\Struct\GLSUserCredentials $credentials = null, $refValue = null, \GlsApi\Struct\GLSDateTime $dateFrom = null, \GlsApi\Struct\GLSDateTime $dateTo = null, $customRef = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setCustomRef($customRef)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \GlsApi\Struct\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\Struct\GLSUserCredentials $credentials
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setCredentials(\GlsApi\Struct\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string|null
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setRefValue($refValue = null)
    {
        // validation for constraint: string
        if (!is_null($refValue) && !is_string($refValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refValue, true), gettype($refValue)), __LINE__);
        }
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return \GlsApi\Struct\GLSDateTime|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param \GlsApi\Struct\GLSDateTime $dateFrom
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setDateFrom(\GlsApi\Struct\GLSDateTime $dateFrom = null)
    {
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return \GlsApi\Struct\GLSDateTime|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param \GlsApi\Struct\GLSDateTime $dateTo
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setDateTo(\GlsApi\Struct\GLSDateTime $dateTo = null)
    {
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get CustomRef value
     * @return string|null
     */
    public function getCustomRef()
    {
        return $this->CustomRef;
    }
    /**
     * Set CustomRef value
     * @param string $customRef
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setCustomRef($customRef = null)
    {
        // validation for constraint: string
        if (!is_null($customRef) && !is_string($customRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customRef, true), gettype($customRef)), __LINE__);
        }
        $this->CustomRef = $customRef;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\Struct\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuListRequestTypeParametersItem) {
            // validation for constraint: itemType
            if (!$tuListRequestTypeParametersItem instanceof \GlsApi\Struct\GLSParameters) {
                $invalidValues[] = is_object($tuListRequestTypeParametersItem) ? get_class($tuListRequestTypeParametersItem) : sprintf('%s(%s)', gettype($tuListRequestTypeParametersItem), var_export($tuListRequestTypeParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameters property can only contain items of type \GlsApi\Struct\GLSParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSParameters[] $parameters
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSParameters $item
     * @return \GlsApi\Struct\TuListRequestType
     */
    public function addToParameters(\GlsApi\Struct\GLSParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\GLSParameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of type \GlsApi\Struct\GLSParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
}
