<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuDetailsRequestType Struct
 * @subpackage Structs
 */
class TuDetailsRequestType extends AbstractStructBase
{
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefValue;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\Struct\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuDetailsRequestType
     * @uses TuDetailsRequestType::setRefValue()
     * @uses TuDetailsRequestType::setCredentials()
     * @uses TuDetailsRequestType::setParameters()
     * @param string $refValue
     * @param \GlsApi\Struct\GLSUserCredentials $credentials
     * @param \GlsApi\Struct\GLSParameters[] $parameters
     */
    public function __construct($refValue = null, \GlsApi\Struct\GLSUserCredentials $credentials = null, array $parameters = array())
    {
        $this
            ->setRefValue($refValue)
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get RefValue value
     * @return string
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GlsApi\Struct\TuDetailsRequestType
     */
    public function setRefValue($refValue = null)
    {
        // validation for constraint: string
        if (!is_null($refValue) && !is_string($refValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refValue, true), gettype($refValue)), __LINE__);
        }
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \GlsApi\Struct\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\Struct\GLSUserCredentials $credentials
     * @return \GlsApi\Struct\TuDetailsRequestType
     */
    public function setCredentials(\GlsApi\Struct\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\Struct\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuDetailsRequestTypeParametersItem) {
            // validation for constraint: itemType
            if (!$tuDetailsRequestTypeParametersItem instanceof \GlsApi\Struct\GLSParameters) {
                $invalidValues[] = is_object($tuDetailsRequestTypeParametersItem) ? get_class($tuDetailsRequestTypeParametersItem) : sprintf('%s(%s)', gettype($tuDetailsRequestTypeParametersItem), var_export($tuDetailsRequestTypeParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameters property can only contain items of type \GlsApi\Struct\GLSParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSParameters[] $parameters
     * @return \GlsApi\Struct\TuDetailsRequestType
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSParameters $item
     * @return \GlsApi\Struct\TuDetailsRequestType
     */
    public function addToParameters(\GlsApi\Struct\GLSParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\GLSParameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of type \GlsApi\Struct\GLSParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
}
