<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSParameters Struct
 * @subpackage Structs
 */
class GLSParameters extends AbstractStructBase
{
    /**
     * The ParamCode
     * @var string
     */
    public $ParamCode;
    /**
     * The ParamValue
     * @var string
     */
    public $ParamValue;
    /**
     * Constructor method for GLSParameters
     * @uses GLSParameters::setParamCode()
     * @uses GLSParameters::setParamValue()
     * @param string $paramCode
     * @param string $paramValue
     */
    public function __construct($paramCode = null, $paramValue = null)
    {
        $this
            ->setParamCode($paramCode)
            ->setParamValue($paramValue);
    }
    /**
     * Get ParamCode value
     * @return string|null
     */
    public function getParamCode()
    {
        return $this->ParamCode;
    }
    /**
     * Set ParamCode value
     * @param string $paramCode
     * @return \GlsApi\Struct\GLSParameters
     */
    public function setParamCode($paramCode = null)
    {
        // validation for constraint: string
        if (!is_null($paramCode) && !is_string($paramCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramCode, true), gettype($paramCode)), __LINE__);
        }
        $this->ParamCode = $paramCode;
        return $this;
    }
    /**
     * Get ParamValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->ParamValue;
    }
    /**
     * Set ParamValue value
     * @param string $paramValue
     * @return \GlsApi\Struct\GLSParameters
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramValue, true), gettype($paramValue)), __LINE__);
        }
        $this->ParamValue = $paramValue;
        return $this;
    }
}
