<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSEvent Struct
 * @subpackage Structs
 */
class GLSEvent extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSDateTime
     */
    public $Date;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LocationCode;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LocationName;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryName;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Desc;
    /**
     * The ReasonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReasonName;
    /**
     * Constructor method for GLSEvent
     * @uses GLSEvent::setDate()
     * @uses GLSEvent::setLocationCode()
     * @uses GLSEvent::setLocationName()
     * @uses GLSEvent::setCountryName()
     * @uses GLSEvent::setCode()
     * @uses GLSEvent::setDesc()
     * @uses GLSEvent::setReasonName()
     * @param \GlsApi\Struct\GLSDateTime $date
     * @param string $locationCode
     * @param string $locationName
     * @param string $countryName
     * @param string $code
     * @param string $desc
     * @param string $reasonName
     */
    public function __construct(\GlsApi\Struct\GLSDateTime $date = null, $locationCode = null, $locationName = null, $countryName = null, $code = null, $desc = null, $reasonName = null)
    {
        $this
            ->setDate($date)
            ->setLocationCode($locationCode)
            ->setLocationName($locationName)
            ->setCountryName($countryName)
            ->setCode($code)
            ->setDesc($desc)
            ->setReasonName($reasonName);
    }
    /**
     * Get Date value
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \GlsApi\Struct\GLSDateTime $date
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setDate(\GlsApi\Struct\GLSDateTime $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Desc value
     * @return string
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param string $desc
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get ReasonName value
     * @return string
     */
    public function getReasonName()
    {
        return $this->ReasonName;
    }
    /**
     * Set ReasonName value
     * @param string $reasonName
     * @return \GlsApi\Struct\GLSEvent
     */
    public function setReasonName($reasonName = null)
    {
        // validation for constraint: string
        if (!is_null($reasonName) && !is_string($reasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonName, true), gettype($reasonName)), __LINE__);
        }
        $this->ReasonName = $reasonName;
        return $this;
    }
}
