<?php

namespace GlsApi\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Service
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\TuDetailsRequestType $getTuDetailRequest
     * @return \GlsApi\Struct\TuDetailsResponseType|bool
     */
    public function GetTuDetail(\GlsApi\Struct\TuDetailsRequestType $getTuDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuDetail($getTuDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\TuListRequestType $getTuListRequest
     * @return \GlsApi\Struct\TuListResponseType|bool
     */
    public function GetTuList(\GlsApi\Struct\TuListRequestType $getTuListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuList($getTuListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuPOD
     * Meta information extracted from the WSDL
     * - documentation: Method to extract the signature of a POD. The result will contain original filename <PODFileName /> and a <PODFile /> that is the binary file encoded in BASE64
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\TuPODRequestType $getTuPODRequest
     * @return \GlsApi\Struct\TuPODResponseType|bool
     */
    public function GetTuPOD(\GlsApi\Struct\TuPODRequestType $getTuPODRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuPOD($getTuPODRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTusDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\Struct\TusDetailsRequestType $getTusDetailsRequest
     * @return \GlsApi\Struct\TusDetailsReponseType|bool
     */
    public function GetTusDetails(\GlsApi\Struct\TusDetailsRequestType $getTusDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTusDetails($getTusDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsApi\Struct\TuDetailsResponseType|\GlsApi\Struct\TuListResponseType|\GlsApi\Struct\TuPODResponseType|\GlsApi\Struct\TusDetailsReponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
