<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSUnitRow Struct
 * @subpackage Structs
 */
class GLSUnitRow extends AbstractStructBase
{
    /**
     * The RefNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefNo;
    /**
     * The InitialDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSDateTime
     */
    public $InitialDateTime;
    /**
     * The EvtCodeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvtCodeNo;
    /**
     * The EvtReasonNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvtReasonNo;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCode;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ZipCode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $City;
    /**
     * The ConsigneeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ConsigneeName;
    /**
     * The ReferenceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceKey;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CurrentStatus;
    /**
     * Constructor method for GLSUnitRow
     * @uses GLSUnitRow::setRefNo()
     * @uses GLSUnitRow::setInitialDateTime()
     * @uses GLSUnitRow::setEvtCodeNo()
     * @uses GLSUnitRow::setEvtReasonNo()
     * @uses GLSUnitRow::setCountryCode()
     * @uses GLSUnitRow::setZipCode()
     * @uses GLSUnitRow::setCity()
     * @uses GLSUnitRow::setConsigneeName()
     * @uses GLSUnitRow::setReferenceKey()
     * @uses GLSUnitRow::setCurrentStatus()
     * @param string $refNo
     * @param \GlsApi\Struct\GLSDateTime $initialDateTime
     * @param string $evtCodeNo
     * @param string $evtReasonNo
     * @param string $countryCode
     * @param string $zipCode
     * @param string $city
     * @param string $consigneeName
     * @param string $referenceKey
     * @param string $currentStatus
     */
    public function __construct($refNo = null, \GlsApi\Struct\GLSDateTime $initialDateTime = null, $evtCodeNo = null, $evtReasonNo = null, $countryCode = null, $zipCode = null, $city = null, $consigneeName = null, $referenceKey = null, $currentStatus = null)
    {
        $this
            ->setRefNo($refNo)
            ->setInitialDateTime($initialDateTime)
            ->setEvtCodeNo($evtCodeNo)
            ->setEvtReasonNo($evtReasonNo)
            ->setCountryCode($countryCode)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setConsigneeName($consigneeName)
            ->setReferenceKey($referenceKey)
            ->setCurrentStatus($currentStatus);
    }
    /**
     * Get RefNo value
     * @return string
     */
    public function getRefNo()
    {
        return $this->RefNo;
    }
    /**
     * Set RefNo value
     * @param string $refNo
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setRefNo($refNo = null)
    {
        // validation for constraint: string
        if (!is_null($refNo) && !is_string($refNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNo, true), gettype($refNo)), __LINE__);
        }
        $this->RefNo = $refNo;
        return $this;
    }
    /**
     * Get InitialDateTime value
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function getInitialDateTime()
    {
        return $this->InitialDateTime;
    }
    /**
     * Set InitialDateTime value
     * @param \GlsApi\Struct\GLSDateTime $initialDateTime
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setInitialDateTime(\GlsApi\Struct\GLSDateTime $initialDateTime = null)
    {
        $this->InitialDateTime = $initialDateTime;
        return $this;
    }
    /**
     * Get EvtCodeNo value
     * @return string
     */
    public function getEvtCodeNo()
    {
        return $this->EvtCodeNo;
    }
    /**
     * Set EvtCodeNo value
     * @param string $evtCodeNo
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setEvtCodeNo($evtCodeNo = null)
    {
        // validation for constraint: string
        if (!is_null($evtCodeNo) && !is_string($evtCodeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evtCodeNo, true), gettype($evtCodeNo)), __LINE__);
        }
        $this->EvtCodeNo = $evtCodeNo;
        return $this;
    }
    /**
     * Get EvtReasonNo value
     * @return string
     */
    public function getEvtReasonNo()
    {
        return $this->EvtReasonNo;
    }
    /**
     * Set EvtReasonNo value
     * @param string $evtReasonNo
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setEvtReasonNo($evtReasonNo = null)
    {
        // validation for constraint: string
        if (!is_null($evtReasonNo) && !is_string($evtReasonNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evtReasonNo, true), gettype($evtReasonNo)), __LINE__);
        }
        $this->EvtReasonNo = $evtReasonNo;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get ConsigneeName value
     * @return string
     */
    public function getConsigneeName()
    {
        return $this->ConsigneeName;
    }
    /**
     * Set ConsigneeName value
     * @param string $consigneeName
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setConsigneeName($consigneeName = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeName) && !is_string($consigneeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeName, true), gettype($consigneeName)), __LINE__);
        }
        $this->ConsigneeName = $consigneeName;
        return $this;
    }
    /**
     * Get ReferenceKey value
     * @return string
     */
    public function getReferenceKey()
    {
        return $this->ReferenceKey;
    }
    /**
     * Set ReferenceKey value
     * @param string $referenceKey
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setReferenceKey($referenceKey = null)
    {
        // validation for constraint: string
        if (!is_null($referenceKey) && !is_string($referenceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceKey, true), gettype($referenceKey)), __LINE__);
        }
        $this->ReferenceKey = $referenceKey;
        return $this;
    }
    /**
     * Get CurrentStatus value
     * @return string
     */
    public function getCurrentStatus()
    {
        return $this->CurrentStatus;
    }
    /**
     * Set CurrentStatus value
     * @param string $currentStatus
     * @return \GlsApi\Struct\GLSUnitRow
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($currentStatus) && !is_string($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentStatus, true), gettype($currentStatus)), __LINE__);
        }
        $this->CurrentStatus = $currentStatus;
        return $this;
    }
}
