<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListResponseType Struct
 * @subpackage Structs
 */
class TuListResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\Struct\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TUList
     * Meta information extracted from the WSDL
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \GlsApi\Struct\GLSUnitRow[]
     */
    public $TUList;
    /**
     * Constructor method for TuListResponseType
     * @uses TuListResponseType::setExitCode()
     * @uses TuListResponseType::setTUList()
     * @param \GlsApi\Struct\GLSExitCode $exitCode
     * @param \GlsApi\Struct\GLSUnitRow[] $tUList
     */
    public function __construct(\GlsApi\Struct\GLSExitCode $exitCode = null, array $tUList = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTUList($tUList);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\Struct\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\Struct\GLSExitCode $exitCode
     * @return \GlsApi\Struct\TuListResponseType
     */
    public function setExitCode(\GlsApi\Struct\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TUList value
     * @return \GlsApi\Struct\GLSUnitRow[]|null
     */
    public function getTUList()
    {
        return $this->TUList;
    }
    /**
     * This method is responsible for validating the values passed to the setTUList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTUList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTUListForArrayConstraintsFromSetTUList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuListResponseTypeTUListItem) {
            // validation for constraint: itemType
            if (!$tuListResponseTypeTUListItem instanceof \GlsApi\Struct\GLSUnitRow) {
                $invalidValues[] = is_object($tuListResponseTypeTUListItem) ? get_class($tuListResponseTypeTUListItem) : sprintf('%s(%s)', gettype($tuListResponseTypeTUListItem), var_export($tuListResponseTypeTUListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TUList property can only contain items of type \GlsApi\Struct\GLSUnitRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TUList value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSUnitRow[] $tUList
     * @return \GlsApi\Struct\TuListResponseType
     */
    public function setTUList(array $tUList = array())
    {
        // validation for constraint: array
        if ('' !== ($tUListArrayErrorMessage = self::validateTUListForArrayConstraintsFromSetTUList($tUList))) {
            throw new \InvalidArgumentException($tUListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10000)
        if (is_array($tUList) && count($tUList) > 10000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10000', count($tUList)), __LINE__);
        }
        $this->TUList = $tUList;
        return $this;
    }
    /**
     * Add item to TUList value
     * @throws \InvalidArgumentException
     * @param \GlsApi\Struct\GLSUnitRow $item
     * @return \GlsApi\Struct\TuListResponseType
     */
    public function addToTUList(\GlsApi\Struct\GLSUnitRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\Struct\GLSUnitRow) {
            throw new \InvalidArgumentException(sprintf('The TUList property can only contain items of type \GlsApi\Struct\GLSUnitRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10000)
        if (is_array($this->TUList) && count($this->TUList) >= 10000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10000', count($this->TUList)), __LINE__);
        }
        $this->TUList[] = $item;
        return $this;
    }
}
