<?php

namespace GlsApi\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSDateTime Struct
 * Meta information extracted from the WSDL
 * - documentation: A datetime with precisions to the hour, all units is 1 based, and hour is less then 24 <br / > Year > 1900, Month 1 = January, Day 1 = first day in month, 0 <= hour > 24, 0 >= Minut > 60
 * @subpackage Structs
 */
class GLSDateTime extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Year;
    /**
     * The Month
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Month;
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Day;
    /**
     * The Hour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Hour;
    /**
     * The Minut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Minut;
    /**
     * Constructor method for GLSDateTime
     * @uses GLSDateTime::setYear()
     * @uses GLSDateTime::setMonth()
     * @uses GLSDateTime::setDay()
     * @uses GLSDateTime::setHour()
     * @uses GLSDateTime::setMinut()
     * @param int $year
     * @param int $month
     * @param int $day
     * @param int $hour
     * @param int $minut
     */
    public function __construct($year = null, $month = null, $day = null, $hour = null, $minut = null)
    {
        $this
            ->setYear($year)
            ->setMonth($month)
            ->setDay($day)
            ->setHour($hour)
            ->setMinut($minut);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get Month value
     * @return int
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Day value
     * @return int
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Hour value
     * @return int
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param int $hour
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function setHour($hour = null)
    {
        // validation for constraint: int
        if (!is_null($hour) && !(is_int($hour) || ctype_digit($hour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Minut value
     * @return int
     */
    public function getMinut()
    {
        return $this->Minut;
    }
    /**
     * Set Minut value
     * @param int $minut
     * @return \GlsApi\Struct\GLSDateTime
     */
    public function setMinut($minut = null)
    {
        // validation for constraint: int
        if (!is_null($minut) && !(is_int($minut) || ctype_digit($minut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minut, true), gettype($minut)), __LINE__);
        }
        $this->Minut = $minut;
        return $this;
    }
}
