<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZReadPrctrResponse StructType
 * @subpackage Structs
 */
class ZReadPrctrResponse extends AbstractStructBase
{
    /**
     * The Confirm
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * @var string
     */
    public $Confirm;
    /**
     * The Prctr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $Prctr;
    /**
     * Constructor method for ZReadPrctrResponse
     * @uses ZReadPrctrResponse::setConfirm()
     * @uses ZReadPrctrResponse::setPrctr()
     * @param string $confirm
     * @param string $prctr
     */
    public function __construct($confirm = null, $prctr = null)
    {
        $this
            ->setConfirm($confirm)
            ->setPrctr($prctr);
    }
    /**
     * Get Confirm value
     * @return string|null
     */
    public function getConfirm()
    {
        return $this->Confirm;
    }
    /**
     * Set Confirm value
     * @param string $confirm
     * @return \StructType\ZReadPrctrResponse
     */
    public function setConfirm($confirm = null)
    {
        // validation for constraint: string
        if (!is_null($confirm) && !is_string($confirm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirm, true), gettype($confirm)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($confirm) && mb_strlen($confirm) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($confirm)), __LINE__);
        }
        $this->Confirm = $confirm;
        return $this;
    }
    /**
     * Get Prctr value
     * @return string|null
     */
    public function getPrctr()
    {
        return $this->Prctr;
    }
    /**
     * Set Prctr value
     * @param string $prctr
     * @return \StructType\ZReadPrctrResponse
     */
    public function setPrctr($prctr = null)
    {
        // validation for constraint: string
        if (!is_null($prctr) && !is_string($prctr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prctr, true), gettype($prctr)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($prctr) && mb_strlen($prctr) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($prctr)), __LINE__);
        }
        $this->Prctr = $prctr;
        return $this;
    }
}
