<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RfcException.Message StructType
 * @subpackage Structs
 */
class RfcException_Message extends AbstractStructBase
{
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - pattern: \d*
     * @var string
     */
    public $Number;
    /**
     * Constructor method for RfcException.Message
     * @uses RfcException_Message::setID()
     * @uses RfcException_Message::setNumber()
     * @param string $iD
     * @param string $number
     */
    public function __construct($iD = null, $number = null)
    {
        $this
            ->setID($iD)
            ->setNumber($number);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RfcException_Message
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\RfcException_Message
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($number) && mb_strlen($number) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($number)), __LINE__);
        }
        // validation for constraint: pattern(\d*)
        if (!is_null($number) && !preg_match('/\\d*/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d*', var_export($number, true)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
}
