<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ZR ServiceType
 * @subpackage Services
 */
class ZR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZReadPrctr
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZReadPrctr $parameters
     * @return \StructType\ZReadPrctrResponse|bool
     */
    public function ZReadPrctr(\StructType\ZReadPrctr $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZReadPrctr($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZReadPrctrResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
