<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZReadPrctr StructType
 * @subpackage Structs
 */
class ZReadPrctr extends AbstractStructBase
{
    /**
     * The EanNew
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $EanNew;
    /**
     * The MatnrNew
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $MatnrNew;
    /**
     * The MatnrRif
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $MatnrRif;
    /**
     * Constructor method for ZReadPrctr
     * @uses ZReadPrctr::setEanNew()
     * @uses ZReadPrctr::setMatnrNew()
     * @uses ZReadPrctr::setMatnrRif()
     * @param string $eanNew
     * @param string $matnrNew
     * @param string $matnrRif
     */
    public function __construct($eanNew = null, $matnrNew = null, $matnrRif = null)
    {
        $this
            ->setEanNew($eanNew)
            ->setMatnrNew($matnrNew)
            ->setMatnrRif($matnrRif);
    }
    /**
     * Get EanNew value
     * @return string|null
     */
    public function getEanNew()
    {
        return $this->EanNew;
    }
    /**
     * Set EanNew value
     * @param string $eanNew
     * @return \StructType\ZReadPrctr
     */
    public function setEanNew($eanNew = null)
    {
        // validation for constraint: string
        if (!is_null($eanNew) && !is_string($eanNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eanNew, true), gettype($eanNew)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($eanNew) && mb_strlen($eanNew) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($eanNew)), __LINE__);
        }
        $this->EanNew = $eanNew;
        return $this;
    }
    /**
     * Get MatnrNew value
     * @return string|null
     */
    public function getMatnrNew()
    {
        return $this->MatnrNew;
    }
    /**
     * Set MatnrNew value
     * @param string $matnrNew
     * @return \StructType\ZReadPrctr
     */
    public function setMatnrNew($matnrNew = null)
    {
        // validation for constraint: string
        if (!is_null($matnrNew) && !is_string($matnrNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matnrNew, true), gettype($matnrNew)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($matnrNew) && mb_strlen($matnrNew) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($matnrNew)), __LINE__);
        }
        $this->MatnrNew = $matnrNew;
        return $this;
    }
    /**
     * Get MatnrRif value
     * @return string|null
     */
    public function getMatnrRif()
    {
        return $this->MatnrRif;
    }
    /**
     * Set MatnrRif value
     * @param string $matnrRif
     * @return \StructType\ZReadPrctr
     */
    public function setMatnrRif($matnrRif = null)
    {
        // validation for constraint: string
        if (!is_null($matnrRif) && !is_string($matnrRif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matnrRif, true), gettype($matnrRif)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($matnrRif) && mb_strlen($matnrRif) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($matnrRif)), __LINE__);
        }
        $this->MatnrRif = $matnrRif;
        return $this;
    }
}
