<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for query StructType
 * @subpackage Structs
 */
class Query extends AbstractStructBase
{
    /**
     * The queryString
     * @var string
     */
    public $queryString;
    /**
     * Constructor method for query
     * @uses Query::setQueryString()
     * @param string $queryString
     */
    public function __construct($queryString = null)
    {
        $this
            ->setQueryString($queryString);
    }
    /**
     * Get queryString value
     * @return string|null
     */
    public function getQueryString()
    {
        return $this->queryString;
    }
    /**
     * Set queryString value
     * @param string $queryString
     * @return \AfhcFacilityFinder\SForce\StructType\Query
     */
    public function setQueryString($queryString = null)
    {
        // validation for constraint: string
        if (!is_null($queryString) && !is_string($queryString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryString, true), gettype($queryString)), __LINE__);
        }
        $this->queryString = $queryString;
        return $this;
    }
}
