<?php

namespace AfhcFacilityFinder\SForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescribeLayout StructType
 * @subpackage Structs
 */
class DescribeLayout extends AbstractStructBase
{
    /**
     * The buttonLayoutSection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection
     */
    public $buttonLayoutSection;
    /**
     * The detailLayoutSections
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[]
     */
    public $detailLayoutSections;
    /**
     * The editLayoutSections
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[]
     */
    public $editLayoutSections;
    /**
     * The feedView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView
     */
    public $feedView;
    /**
     * The highlightsPanelLayoutSection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection
     */
    public $highlightsPanelLayoutSection;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $id;
    /**
     * The quickActionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult
     */
    public $quickActionList;
    /**
     * The relatedContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\RelatedContent
     */
    public $relatedContent;
    /**
     * The relatedLists
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\RelatedList[]
     */
    public $relatedLists;
    /**
     * The saveOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption[]
     */
    public $saveOptions;
    /**
     * Constructor method for DescribeLayout
     * @uses DescribeLayout::setButtonLayoutSection()
     * @uses DescribeLayout::setDetailLayoutSections()
     * @uses DescribeLayout::setEditLayoutSections()
     * @uses DescribeLayout::setFeedView()
     * @uses DescribeLayout::setHighlightsPanelLayoutSection()
     * @uses DescribeLayout::setId()
     * @uses DescribeLayout::setQuickActionList()
     * @uses DescribeLayout::setRelatedContent()
     * @uses DescribeLayout::setRelatedLists()
     * @uses DescribeLayout::setSaveOptions()
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection $buttonLayoutSection
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[] $detailLayoutSections
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[] $editLayoutSections
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView $feedView
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $highlightsPanelLayoutSection
     * @param string $id
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult $quickActionList
     * @param \AfhcFacilityFinder\SForce\StructType\RelatedContent $relatedContent
     * @param \AfhcFacilityFinder\SForce\StructType\RelatedList[] $relatedLists
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption[] $saveOptions
     */
    public function __construct(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection $buttonLayoutSection = null, array $detailLayoutSections = array(), array $editLayoutSections = array(), \AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView $feedView = null, \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $highlightsPanelLayoutSection = null, $id = null, \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult $quickActionList = null, \AfhcFacilityFinder\SForce\StructType\RelatedContent $relatedContent = null, array $relatedLists = array(), array $saveOptions = array())
    {
        $this
            ->setButtonLayoutSection($buttonLayoutSection)
            ->setDetailLayoutSections($detailLayoutSections)
            ->setEditLayoutSections($editLayoutSections)
            ->setFeedView($feedView)
            ->setHighlightsPanelLayoutSection($highlightsPanelLayoutSection)
            ->setId($id)
            ->setQuickActionList($quickActionList)
            ->setRelatedContent($relatedContent)
            ->setRelatedLists($relatedLists)
            ->setSaveOptions($saveOptions);
    }
    /**
     * Get buttonLayoutSection value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection|null
     */
    public function getButtonLayoutSection()
    {
        return $this->buttonLayoutSection;
    }
    /**
     * Set buttonLayoutSection value
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection $buttonLayoutSection
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setButtonLayoutSection(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutButtonSection $buttonLayoutSection = null)
    {
        $this->buttonLayoutSection = $buttonLayoutSection;
        return $this;
    }
    /**
     * Get detailLayoutSections value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[]|null
     */
    public function getDetailLayoutSections()
    {
        return $this->detailLayoutSections;
    }
    /**
     * This method is responsible for validating the values passed to the setDetailLayoutSections method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetailLayoutSections method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailLayoutSectionsForArrayConstraintsFromSetDetailLayoutSections(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutDetailLayoutSectionsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutDetailLayoutSectionsItem instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection) {
                $invalidValues[] = is_object($describeLayoutDetailLayoutSectionsItem) ? get_class($describeLayoutDetailLayoutSectionsItem) : sprintf('%s(%s)', gettype($describeLayoutDetailLayoutSectionsItem), var_export($describeLayoutDetailLayoutSectionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The detailLayoutSections property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set detailLayoutSections value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[] $detailLayoutSections
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setDetailLayoutSections(array $detailLayoutSections = array())
    {
        // validation for constraint: array
        if ('' !== ($detailLayoutSectionsArrayErrorMessage = self::validateDetailLayoutSectionsForArrayConstraintsFromSetDetailLayoutSections($detailLayoutSections))) {
            throw new \InvalidArgumentException($detailLayoutSectionsArrayErrorMessage, __LINE__);
        }
        $this->detailLayoutSections = $detailLayoutSections;
        return $this;
    }
    /**
     * Add item to detailLayoutSections value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function addToDetailLayoutSections(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection) {
            throw new \InvalidArgumentException(sprintf('The detailLayoutSections property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->detailLayoutSections[] = $item;
        return $this;
    }
    /**
     * Get editLayoutSections value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[]|null
     */
    public function getEditLayoutSections()
    {
        return $this->editLayoutSections;
    }
    /**
     * This method is responsible for validating the values passed to the setEditLayoutSections method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEditLayoutSections method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEditLayoutSectionsForArrayConstraintsFromSetEditLayoutSections(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutEditLayoutSectionsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutEditLayoutSectionsItem instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection) {
                $invalidValues[] = is_object($describeLayoutEditLayoutSectionsItem) ? get_class($describeLayoutEditLayoutSectionsItem) : sprintf('%s(%s)', gettype($describeLayoutEditLayoutSectionsItem), var_export($describeLayoutEditLayoutSectionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The editLayoutSections property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set editLayoutSections value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection[] $editLayoutSections
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setEditLayoutSections(array $editLayoutSections = array())
    {
        // validation for constraint: array
        if ('' !== ($editLayoutSectionsArrayErrorMessage = self::validateEditLayoutSectionsForArrayConstraintsFromSetEditLayoutSections($editLayoutSections))) {
            throw new \InvalidArgumentException($editLayoutSectionsArrayErrorMessage, __LINE__);
        }
        $this->editLayoutSections = $editLayoutSections;
        return $this;
    }
    /**
     * Add item to editLayoutSections value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function addToEditLayoutSections(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection) {
            throw new \InvalidArgumentException(sprintf('The editLayoutSections property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->editLayoutSections[] = $item;
        return $this;
    }
    /**
     * Get feedView value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView|null
     */
    public function getFeedView()
    {
        return $this->feedView;
    }
    /**
     * Set feedView value
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView $feedView
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setFeedView(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutFeedView $feedView = null)
    {
        $this->feedView = $feedView;
        return $this;
    }
    /**
     * Get highlightsPanelLayoutSection value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection|null
     */
    public function getHighlightsPanelLayoutSection()
    {
        return $this->highlightsPanelLayoutSection;
    }
    /**
     * Set highlightsPanelLayoutSection value
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $highlightsPanelLayoutSection
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setHighlightsPanelLayoutSection(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutSection $highlightsPanelLayoutSection = null)
    {
        $this->highlightsPanelLayoutSection = $highlightsPanelLayoutSection;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($id) && mb_strlen($id) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($id) && !preg_match('/[a-zA-Z0-9]{18}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get quickActionList value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult|null
     */
    public function getQuickActionList()
    {
        return $this->quickActionList;
    }
    /**
     * Set quickActionList value
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult $quickActionList
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setQuickActionList(\AfhcFacilityFinder\SForce\StructType\DescribeQuickActionListResult $quickActionList = null)
    {
        $this->quickActionList = $quickActionList;
        return $this;
    }
    /**
     * Get relatedContent value
     * @return \AfhcFacilityFinder\SForce\StructType\RelatedContent|null
     */
    public function getRelatedContent()
    {
        return $this->relatedContent;
    }
    /**
     * Set relatedContent value
     * @param \AfhcFacilityFinder\SForce\StructType\RelatedContent $relatedContent
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setRelatedContent(\AfhcFacilityFinder\SForce\StructType\RelatedContent $relatedContent = null)
    {
        $this->relatedContent = $relatedContent;
        return $this;
    }
    /**
     * Get relatedLists value
     * @return \AfhcFacilityFinder\SForce\StructType\RelatedList[]|null
     */
    public function getRelatedLists()
    {
        return $this->relatedLists;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedLists method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedLists method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedListsForArrayConstraintsFromSetRelatedLists(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutRelatedListsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutRelatedListsItem instanceof \AfhcFacilityFinder\SForce\StructType\RelatedList) {
                $invalidValues[] = is_object($describeLayoutRelatedListsItem) ? get_class($describeLayoutRelatedListsItem) : sprintf('%s(%s)', gettype($describeLayoutRelatedListsItem), var_export($describeLayoutRelatedListsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedLists property can only contain items of type \AfhcFacilityFinder\SForce\StructType\RelatedList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedLists value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\RelatedList[] $relatedLists
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setRelatedLists(array $relatedLists = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedListsArrayErrorMessage = self::validateRelatedListsForArrayConstraintsFromSetRelatedLists($relatedLists))) {
            throw new \InvalidArgumentException($relatedListsArrayErrorMessage, __LINE__);
        }
        $this->relatedLists = $relatedLists;
        return $this;
    }
    /**
     * Add item to relatedLists value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\RelatedList $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function addToRelatedLists(\AfhcFacilityFinder\SForce\StructType\RelatedList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\RelatedList) {
            throw new \InvalidArgumentException(sprintf('The relatedLists property can only contain items of type \AfhcFacilityFinder\SForce\StructType\RelatedList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedLists[] = $item;
        return $this;
    }
    /**
     * Get saveOptions value
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption[]|null
     */
    public function getSaveOptions()
    {
        return $this->saveOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setSaveOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaveOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaveOptionsForArrayConstraintsFromSetSaveOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeLayoutSaveOptionsItem) {
            // validation for constraint: itemType
            if (!$describeLayoutSaveOptionsItem instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption) {
                $invalidValues[] = is_object($describeLayoutSaveOptionsItem) ? get_class($describeLayoutSaveOptionsItem) : sprintf('%s(%s)', gettype($describeLayoutSaveOptionsItem), var_export($describeLayoutSaveOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The saveOptions property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set saveOptions value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption[] $saveOptions
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function setSaveOptions(array $saveOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($saveOptionsArrayErrorMessage = self::validateSaveOptionsForArrayConstraintsFromSetSaveOptions($saveOptions))) {
            throw new \InvalidArgumentException($saveOptionsArrayErrorMessage, __LINE__);
        }
        $this->saveOptions = $saveOptions;
        return $this;
    }
    /**
     * Add item to saveOptions value
     * @throws \InvalidArgumentException
     * @param \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption $item
     * @return \AfhcFacilityFinder\SForce\StructType\DescribeLayout
     */
    public function addToSaveOptions(\AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption) {
            throw new \InvalidArgumentException(sprintf('The saveOptions property can only contain items of type \AfhcFacilityFinder\SForce\StructType\DescribeLayoutSaveOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->saveOptions[] = $item;
        return $this;
    }
}
