<?php

namespace AfhcFacilityFinder\SForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the CallOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCallOptions(\AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CallOptions', $callOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the DuplicateRuleHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader $duplicateRuleHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDuplicateRuleHeader(\AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader $duplicateRuleHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DuplicateRuleHeader', $duplicateRuleHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named findDuplicates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, DuplicateRuleHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader
     * - SOAPHeaders: required, required, required, required
     * - documentation: Find duplicates for a set of sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\FindDuplicates $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\FindDuplicatesResponse|bool
     */
    public function findDuplicates(\AfhcFacilityFinder\SForce\StructType\FindDuplicates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findDuplicates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findDuplicatesByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, DuplicateRuleHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader
     * - SOAPHeaders: required, required, required, required
     * - documentation: Find duplicates for a set of ids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\FindDuplicatesByIds $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\FindDuplicatesByIdsResponse|bool
     */
    public function findDuplicatesByIds(\AfhcFacilityFinder\SForce\StructType\FindDuplicatesByIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findDuplicatesByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AfhcFacilityFinder\SForce\StructType\FindDuplicatesByIdsResponse|\AfhcFacilityFinder\SForce\StructType\FindDuplicatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
