<?php

namespace AfhcFacilityFinder\SForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\AfhcFacilityFinder\SForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the CallOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCallOptions(\AfhcFacilityFinder\SForce\StructType\CallOptions $callOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CallOptions', $callOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\AfhcFacilityFinder\SForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserTerritoryDeleteHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\UserTerritoryDeleteHeader $userTerritoryDeleteHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserTerritoryDeleteHeader(\AfhcFacilityFinder\SForce\StructType\UserTerritoryDeleteHeader $userTerritoryDeleteHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserTerritoryDeleteHeader', $userTerritoryDeleteHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the EmailHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\EmailHeader $emailHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEmailHeader(\AfhcFacilityFinder\SForce\StructType\EmailHeader $emailHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EmailHeader', $emailHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AllowFieldTruncationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader $allowFieldTruncationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAllowFieldTruncationHeader(\AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader $allowFieldTruncationHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AllowFieldTruncationHeader', $allowFieldTruncationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the DisableFeedTrackingHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader $disableFeedTrackingHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDisableFeedTrackingHeader(\AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader $disableFeedTrackingHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DisableFeedTrackingHeader', $disableFeedTrackingHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the StreamingEnabledHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader $streamingEnabledHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderStreamingEnabledHeader(\AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader $streamingEnabledHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'StreamingEnabledHeader', $streamingEnabledHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AllOrNoneHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader $allOrNoneHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAllOrNoneHeader(\AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader $allOrNoneHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AllOrNoneHeader', $allOrNoneHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the DuplicateRuleHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader $duplicateRuleHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDuplicateRuleHeader(\AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader $duplicateRuleHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DuplicateRuleHeader', $duplicateRuleHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\AfhcFacilityFinder\SForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the DebuggingHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AfhcFacilityFinder\SForce\StructType\DebuggingHeader $debuggingHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDebuggingHeader(\AfhcFacilityFinder\SForce\StructType\DebuggingHeader $debuggingHeader, $nameSpace = 'urn:partner.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DebuggingHeader', $debuggingHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named delete
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, UserTerritoryDeleteHeader, EmailHeader, AllowFieldTruncationHeader, DisableFeedTrackingHeader, StreamingEnabledHeader, AllOrNoneHeader, DuplicateRuleHeader, LocaleOptions, DebuggingHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\UserTerritoryDeleteHeader, \AfhcFacilityFinder\SForce\StructType\EmailHeader, \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader, \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader, \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader, \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader, \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions, \AfhcFacilityFinder\SForce\StructType\DebuggingHeader
     * - SOAPHeaders: required, required, required, required, required, required, required, required, required, required, required, required
     * - documentation: Delete a set of sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\Delete $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DeleteResponse|bool
     */
    public function delete(\AfhcFacilityFinder\SForce\StructType\Delete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->delete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteByExample
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, CallOptions, PackageVersionHeader, UserTerritoryDeleteHeader, EmailHeader, AllowFieldTruncationHeader, DisableFeedTrackingHeader, StreamingEnabledHeader, AllOrNoneHeader, DuplicateRuleHeader, LocaleOptions, DebuggingHeader
     * - SOAPHeaderNamespaces: urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com, urn:partner.soap.sforce.com
     * - SOAPHeaderTypes: \AfhcFacilityFinder\SForce\StructType\SessionHeader, \AfhcFacilityFinder\SForce\StructType\CallOptions, \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader, \AfhcFacilityFinder\SForce\StructType\UserTerritoryDeleteHeader, \AfhcFacilityFinder\SForce\StructType\EmailHeader, \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader, \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader, \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader, \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader, \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader, \AfhcFacilityFinder\SForce\StructType\LocaleOptions, \AfhcFacilityFinder\SForce\StructType\DebuggingHeader
     * - SOAPHeaders: required, required, required, required, required, required, required, required, required, required, required, required
     * - documentation: Delete a set of SObjects by example. The passed SObject is a template for the object to delete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AfhcFacilityFinder\SForce\StructType\DeleteByExample $parameters
     * @return \AfhcFacilityFinder\SForce\StructType\DeleteByExampleResponse|bool
     */
    public function deleteByExample(\AfhcFacilityFinder\SForce\StructType\DeleteByExample $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteByExample($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AfhcFacilityFinder\SForce\StructType\DeleteByExampleResponse|\AfhcFacilityFinder\SForce\StructType\DeleteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
