<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \AfhcFacilityFinder\SForce\ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \AfhcFacilityFinder\SForce\ServiceType\Login($options);
$login->setSoapHeaderLoginScopeHeader(new \AfhcFacilityFinder\SForce\StructType\LoginScopeHeader());
$login->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for login operation/method
 */
if ($login->login(new \AfhcFacilityFinder\SForce\StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Describe ServiceType
 */
$describe = new \AfhcFacilityFinder\SForce\ServiceType\Describe($options);
$describe->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$describe->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$describe->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$describe->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
/**
 * Sample call for describeSObject operation/method
 */
if ($describe->describeSObject(new \AfhcFacilityFinder\SForce\StructType\DescribeSObject()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSObjects operation/method
 */
if ($describe->describeSObjects(new \AfhcFacilityFinder\SForce\StructType\DescribeSObjects()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeGlobal operation/method
 */
if ($describe->describeGlobal(new \AfhcFacilityFinder\SForce\StructType\DescribeGlobal()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryGroups operation/method
 */
if ($describe->describeDataCategoryGroups(new \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroups()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryGroupStructures operation/method
 */
if ($describe->describeDataCategoryGroupStructures(new \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryGroupStructures()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryMappings operation/method
 */
if ($describe->describeDataCategoryMappings(new \AfhcFacilityFinder\SForce\StructType\DescribeDataCategoryMappings()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeKnowledgeSettings operation/method
 */
if ($describe->describeKnowledgeSettings(new \AfhcFacilityFinder\SForce\StructType\DescribeKnowledgeSettings()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAppMenu operation/method
 */
if ($describe->describeAppMenu(new \AfhcFacilityFinder\SForce\StructType\DescribeAppMenu()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeGlobalTheme operation/method
 */
if ($describe->describeGlobalTheme(new \AfhcFacilityFinder\SForce\StructType\DescribeGlobalTheme_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeTheme operation/method
 */
if ($describe->describeTheme(new \AfhcFacilityFinder\SForce\StructType\DescribeTheme()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeLayout operation/method
 */
if ($describe->describeLayout(new \AfhcFacilityFinder\SForce\StructType\DescribeLayout_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSoftphoneLayout operation/method
 */
if ($describe->describeSoftphoneLayout(new \AfhcFacilityFinder\SForce\StructType\DescribeSoftphoneLayout()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchLayouts operation/method
 */
if ($describe->describeSearchLayouts(new \AfhcFacilityFinder\SForce\StructType\DescribeSearchLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchableEntities operation/method
 */
if ($describe->describeSearchableEntities(new \AfhcFacilityFinder\SForce\StructType\DescribeSearchableEntities()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchScopeOrder operation/method
 */
if ($describe->describeSearchScopeOrder(new \AfhcFacilityFinder\SForce\StructType\DescribeSearchScopeOrder()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeCompactLayouts operation/method
 */
if ($describe->describeCompactLayouts(new \AfhcFacilityFinder\SForce\StructType\DescribeCompactLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describePathAssistants operation/method
 */
if ($describe->describePathAssistants(new \AfhcFacilityFinder\SForce\StructType\DescribePathAssistants()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeApprovalLayout operation/method
 */
if ($describe->describeApprovalLayout(new \AfhcFacilityFinder\SForce\StructType\DescribeApprovalLayout_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSoqlListViews operation/method
 */
if ($describe->describeSoqlListViews(new \AfhcFacilityFinder\SForce\StructType\DescribeSoqlListViews()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSObjectListViews operation/method
 */
if ($describe->describeSObjectListViews(new \AfhcFacilityFinder\SForce\StructType\DescribeSObjectListViews()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeTabs operation/method
 */
if ($describe->describeTabs(new \AfhcFacilityFinder\SForce\StructType\DescribeTabs()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAllTabs operation/method
 */
if ($describe->describeAllTabs(new \AfhcFacilityFinder\SForce\StructType\DescribeAllTabs()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describePrimaryCompactLayouts operation/method
 */
if ($describe->describePrimaryCompactLayouts(new \AfhcFacilityFinder\SForce\StructType\DescribePrimaryCompactLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeQuickActions operation/method
 */
if ($describe->describeQuickActions(new \AfhcFacilityFinder\SForce\StructType\DescribeQuickActions()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeQuickActionsForRecordType operation/method
 */
if ($describe->describeQuickActionsForRecordType(new \AfhcFacilityFinder\SForce\StructType\DescribeQuickActionsForRecordType()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAvailableQuickActions operation/method
 */
if ($describe->describeAvailableQuickActions(new \AfhcFacilityFinder\SForce\StructType\DescribeAvailableQuickActions()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeVisualForce operation/method
 */
if ($describe->describeVisualForce(new \AfhcFacilityFinder\SForce\StructType\DescribeVisualForce()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeNouns operation/method
 */
if ($describe->describeNouns(new \AfhcFacilityFinder\SForce\StructType\DescribeNouns()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \AfhcFacilityFinder\SForce\ServiceType\Execute($options);
$execute->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$execute->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$execute->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
/**
 * Sample call for executeListView operation/method
 */
if ($execute->executeListView(new \AfhcFacilityFinder\SForce\StructType\ExecuteListView()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \AfhcFacilityFinder\SForce\ServiceType\Create($options);
$create->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$create->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$create->setSoapHeaderAssignmentRuleHeader(new \AfhcFacilityFinder\SForce\StructType\AssignmentRuleHeader());
$create->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$create->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$create->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$create->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$create->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$create->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$create->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$create->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$create->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$create->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
/**
 * Sample call for create operation/method
 */
if ($create->create(new \AfhcFacilityFinder\SForce\StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \AfhcFacilityFinder\SForce\ServiceType\Update($options);
$update->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$update->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$update->setSoapHeaderAssignmentRuleHeader(new \AfhcFacilityFinder\SForce\StructType\AssignmentRuleHeader());
$update->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$update->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$update->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$update->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$update->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$update->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$update->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$update->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$update->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$update->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
$update->setSoapHeaderOwnerChangeOptions(new \AfhcFacilityFinder\SForce\StructType\OwnerChangeOptions());
/**
 * Sample call for update operation/method
 */
if ($update->update(new \AfhcFacilityFinder\SForce\StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Upsert ServiceType
 */
$upsert = new \AfhcFacilityFinder\SForce\ServiceType\Upsert($options);
$upsert->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$upsert->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$upsert->setSoapHeaderAssignmentRuleHeader(new \AfhcFacilityFinder\SForce\StructType\AssignmentRuleHeader());
$upsert->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$upsert->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$upsert->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$upsert->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$upsert->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$upsert->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$upsert->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$upsert->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$upsert->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$upsert->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
$upsert->setSoapHeaderOwnerChangeOptions(new \AfhcFacilityFinder\SForce\StructType\OwnerChangeOptions());
/**
 * Sample call for upsert operation/method
 */
if ($upsert->upsert(new \AfhcFacilityFinder\SForce\StructType\Upsert()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \AfhcFacilityFinder\SForce\ServiceType\Merge($options);
$merge->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$merge->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$merge->setSoapHeaderAssignmentRuleHeader(new \AfhcFacilityFinder\SForce\StructType\AssignmentRuleHeader());
$merge->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$merge->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$merge->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$merge->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$merge->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$merge->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$merge->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$merge->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$merge->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
/**
 * Sample call for merge operation/method
 */
if ($merge->merge(new \AfhcFacilityFinder\SForce\StructType\Merge()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \AfhcFacilityFinder\SForce\ServiceType\Delete($options);
$delete->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$delete->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$delete->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$delete->setSoapHeaderUserTerritoryDeleteHeader(new \AfhcFacilityFinder\SForce\StructType\UserTerritoryDeleteHeader());
$delete->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
$delete->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$delete->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$delete->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$delete->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$delete->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$delete->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$delete->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \AfhcFacilityFinder\SForce\StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteByExample operation/method
 */
if ($delete->deleteByExample(new \AfhcFacilityFinder\SForce\StructType\DeleteByExample()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Undelete ServiceType
 */
$undelete = new \AfhcFacilityFinder\SForce\ServiceType\Undelete($options);
$undelete->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$undelete->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$undelete->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$undelete->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$undelete->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$undelete->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$undelete->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$undelete->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$undelete->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$undelete->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
/**
 * Sample call for undelete operation/method
 */
if ($undelete->undelete(new \AfhcFacilityFinder\SForce\StructType\Undelete()) !== false) {
    print_r($undelete->getResult());
} else {
    print_r($undelete->getLastError());
}
/**
 * Samples for Empty ServiceType
 */
$empty = new \AfhcFacilityFinder\SForce\ServiceType\_Empty($options);
$empty->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$empty->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for emptyRecycleBin operation/method
 */
if ($empty->emptyRecycleBin(new \AfhcFacilityFinder\SForce\StructType\EmptyRecycleBin()) !== false) {
    print_r($empty->getResult());
} else {
    print_r($empty->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \AfhcFacilityFinder\SForce\ServiceType\Retrieve($options);
$retrieve->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$retrieve->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$retrieve->setSoapHeaderQueryOptions(new \AfhcFacilityFinder\SForce\StructType\QueryOptions());
$retrieve->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$retrieve->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$retrieve->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
/**
 * Sample call for retrieve operation/method
 */
if ($retrieve->retrieve(new \AfhcFacilityFinder\SForce\StructType\Retrieve()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveQuickActionTemplates operation/method
 */
if ($retrieve->retrieveQuickActionTemplates(new \AfhcFacilityFinder\SForce\StructType\RetrieveQuickActionTemplates()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveMassQuickActionTemplates operation/method
 */
if ($retrieve->retrieveMassQuickActionTemplates(new \AfhcFacilityFinder\SForce\StructType\RetrieveMassQuickActionTemplates()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \AfhcFacilityFinder\SForce\ServiceType\Process($options);
$process->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$process->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$process->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$process->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$process->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$process->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$process->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$process->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$process->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
/**
 * Sample call for process operation/method
 */
if ($process->process(new \AfhcFacilityFinder\SForce\StructType\Process()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \AfhcFacilityFinder\SForce\ServiceType\Convert($options);
$convert->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$convert->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$convert->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$convert->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$convert->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$convert->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$convert->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$convert->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$convert->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
/**
 * Sample call for convertLead operation/method
 */
if ($convert->convertLead(new \AfhcFacilityFinder\SForce\StructType\ConvertLead()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \AfhcFacilityFinder\SForce\ServiceType\Logout($options);
$logout->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$logout->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for logout operation/method
 */
if ($logout->logout(new \AfhcFacilityFinder\SForce\StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \AfhcFacilityFinder\SForce\ServiceType\Invalidate($options);
$invalidate->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$invalidate->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for invalidateSessions operation/method
 */
if ($invalidate->invalidateSessions(new \AfhcFacilityFinder\SForce\StructType\InvalidateSessions()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \AfhcFacilityFinder\SForce\ServiceType\Get($options);
$get->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$get->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for getDeleted operation/method
 */
if ($get->getDeleted(new \AfhcFacilityFinder\SForce\StructType\GetDeleted()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUpdated operation/method
 */
if ($get->getUpdated(new \AfhcFacilityFinder\SForce\StructType\GetUpdated()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServerTimestamp operation/method
 */
if ($get->getServerTimestamp(new \AfhcFacilityFinder\SForce\StructType\GetServerTimestamp()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserInfo operation/method
 */
if ($get->getUserInfo(new \AfhcFacilityFinder\SForce\StructType\GetUserInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \AfhcFacilityFinder\SForce\ServiceType\Query($options);
$query->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$query->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$query->setSoapHeaderQueryOptions(new \AfhcFacilityFinder\SForce\StructType\QueryOptions());
$query->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$query->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
/**
 * Sample call for query operation/method
 */
if ($query->query(new \AfhcFacilityFinder\SForce\StructType\Query()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryAll operation/method
 */
if ($query->queryAll(new \AfhcFacilityFinder\SForce\StructType\QueryAll()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryMore operation/method
 */
if ($query->queryMore(new \AfhcFacilityFinder\SForce\StructType\QueryMore()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \AfhcFacilityFinder\SForce\ServiceType\Search($options);
$search->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$search->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$search->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
/**
 * Sample call for search operation/method
 */
if ($search->search(new \AfhcFacilityFinder\SForce\StructType\Search()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \AfhcFacilityFinder\SForce\ServiceType\Set($options);
$set->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$set->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for setPassword operation/method
 */
if ($set->setPassword(new \AfhcFacilityFinder\SForce\StructType\SetPassword()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \AfhcFacilityFinder\SForce\ServiceType\Change($options);
$change->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$change->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for changeOwnPassword operation/method
 */
if ($change->changeOwnPassword(new \AfhcFacilityFinder\SForce\StructType\ChangeOwnPassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \AfhcFacilityFinder\SForce\ServiceType\Reset($options);
$reset->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$reset->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$reset->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
/**
 * Sample call for resetPassword operation/method
 */
if ($reset->resetPassword(new \AfhcFacilityFinder\SForce\StructType\ResetPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \AfhcFacilityFinder\SForce\ServiceType\Send($options);
$send->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$send->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for sendEmailMessage operation/method
 */
if ($send->sendEmailMessage(new \AfhcFacilityFinder\SForce\StructType\SendEmailMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendEmail operation/method
 */
if ($send->sendEmail(new \AfhcFacilityFinder\SForce\StructType\SendEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Render ServiceType
 */
$render = new \AfhcFacilityFinder\SForce\ServiceType\Render($options);
$render->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$render->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
/**
 * Sample call for renderEmailTemplate operation/method
 */
if ($render->renderEmailTemplate(new \AfhcFacilityFinder\SForce\StructType\RenderEmailTemplate()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Sample call for renderStoredEmailTemplate operation/method
 */
if ($render->renderStoredEmailTemplate(new \AfhcFacilityFinder\SForce\StructType\RenderStoredEmailTemplate()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \AfhcFacilityFinder\SForce\ServiceType\Perform($options);
$perform->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$perform->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$perform->setSoapHeaderAssignmentRuleHeader(new \AfhcFacilityFinder\SForce\StructType\AssignmentRuleHeader());
$perform->setSoapHeaderMruHeader(new \AfhcFacilityFinder\SForce\StructType\MruHeader());
$perform->setSoapHeaderAllowFieldTruncationHeader(new \AfhcFacilityFinder\SForce\StructType\AllowFieldTruncationHeader());
$perform->setSoapHeaderDisableFeedTrackingHeader(new \AfhcFacilityFinder\SForce\StructType\DisableFeedTrackingHeader());
$perform->setSoapHeaderStreamingEnabledHeader(new \AfhcFacilityFinder\SForce\StructType\StreamingEnabledHeader());
$perform->setSoapHeaderAllOrNoneHeader(new \AfhcFacilityFinder\SForce\StructType\AllOrNoneHeader());
$perform->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
$perform->setSoapHeaderLocaleOptions(new \AfhcFacilityFinder\SForce\StructType\LocaleOptions());
$perform->setSoapHeaderDebuggingHeader(new \AfhcFacilityFinder\SForce\StructType\DebuggingHeader());
$perform->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$perform->setSoapHeaderEmailHeader(new \AfhcFacilityFinder\SForce\StructType\EmailHeader());
$perform->setSoapHeaderOwnerChangeOptions(new \AfhcFacilityFinder\SForce\StructType\OwnerChangeOptions());
/**
 * Sample call for performQuickActions operation/method
 */
if ($perform->performQuickActions(new \AfhcFacilityFinder\SForce\StructType\PerformQuickActions()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \AfhcFacilityFinder\SForce\ServiceType\Find($options);
$find->setSoapHeaderSessionHeader(new \AfhcFacilityFinder\SForce\StructType\SessionHeader());
$find->setSoapHeaderCallOptions(new \AfhcFacilityFinder\SForce\StructType\CallOptions());
$find->setSoapHeaderPackageVersionHeader(new \AfhcFacilityFinder\SForce\StructType\PackageVersionHeader());
$find->setSoapHeaderDuplicateRuleHeader(new \AfhcFacilityFinder\SForce\StructType\DuplicateRuleHeader());
/**
 * Sample call for findDuplicates operation/method
 */
if ($find->findDuplicates(new \AfhcFacilityFinder\SForce\StructType\FindDuplicates()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findDuplicatesByIds operation/method
 */
if ($find->findDuplicatesByIds(new \AfhcFacilityFinder\SForce\StructType\FindDuplicatesByIds()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
